<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AASegmentSeatInventoriesType StructType
 * @subpackage Structs
 */
class AASegmentSeatInventoriesType extends AbstractStructBase
{
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * The depatureDate
     * @var string
     */
    public $depatureDate;
    /**
     * The cabinClass
     * @var string
     */
    public $cabinClass;
    /**
     * The allocatedSeats
     * @var int
     */
    public $allocatedSeats;
    /**
     * The oversellSeats
     * @var int
     */
    public $oversellSeats;
    /**
     * The curtailedSeats
     * @var int
     */
    public $curtailedSeats;
    /**
     * The seatsSold
     * @var int
     */
    public $seatsSold;
    /**
     * The onHoldSeats
     * @var int
     */
    public $onHoldSeats;
    /**
     * The fixedSeats
     * @var int
     */
    public $fixedSeats;
    /**
     * The availableSeats
     * @var int
     */
    public $availableSeats;
    /**
     * The infantAllocation
     * @var int
     */
    public $infantAllocation;
    /**
     * The soldInfantSeats
     * @var int
     */
    public $soldInfantSeats;
    /**
     * The onholdInfantSeats
     * @var int
     */
    public $onholdInfantSeats;
    /**
     * The availableInfantSeats
     * @var int
     */
    public $availableInfantSeats;
    /**
     * The seatAllocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AASeatBCAllocationsType[]
     */
    public $seatAllocations;
    /**
     * Constructor method for AASegmentSeatInventoriesType
     * @uses AASegmentSeatInventoriesType::setFlightNumber()
     * @uses AASegmentSeatInventoriesType::setSegmentCode()
     * @uses AASegmentSeatInventoriesType::setDepatureDate()
     * @uses AASegmentSeatInventoriesType::setCabinClass()
     * @uses AASegmentSeatInventoriesType::setAllocatedSeats()
     * @uses AASegmentSeatInventoriesType::setOversellSeats()
     * @uses AASegmentSeatInventoriesType::setCurtailedSeats()
     * @uses AASegmentSeatInventoriesType::setSeatsSold()
     * @uses AASegmentSeatInventoriesType::setOnHoldSeats()
     * @uses AASegmentSeatInventoriesType::setFixedSeats()
     * @uses AASegmentSeatInventoriesType::setAvailableSeats()
     * @uses AASegmentSeatInventoriesType::setInfantAllocation()
     * @uses AASegmentSeatInventoriesType::setSoldInfantSeats()
     * @uses AASegmentSeatInventoriesType::setOnholdInfantSeats()
     * @uses AASegmentSeatInventoriesType::setAvailableInfantSeats()
     * @uses AASegmentSeatInventoriesType::setSeatAllocations()
     * @param string $flightNumber
     * @param string $segmentCode
     * @param string $depatureDate
     * @param string $cabinClass
     * @param int $allocatedSeats
     * @param int $oversellSeats
     * @param int $curtailedSeats
     * @param int $seatsSold
     * @param int $onHoldSeats
     * @param int $fixedSeats
     * @param int $availableSeats
     * @param int $infantAllocation
     * @param int $soldInfantSeats
     * @param int $onholdInfantSeats
     * @param int $availableInfantSeats
     * @param \StructType\AASeatBCAllocationsType[] $seatAllocations
     */
    public function __construct($flightNumber = null, $segmentCode = null, $depatureDate = null, $cabinClass = null, $allocatedSeats = null, $oversellSeats = null, $curtailedSeats = null, $seatsSold = null, $onHoldSeats = null, $fixedSeats = null, $availableSeats = null, $infantAllocation = null, $soldInfantSeats = null, $onholdInfantSeats = null, $availableInfantSeats = null, array $seatAllocations = array())
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setSegmentCode($segmentCode)
            ->setDepatureDate($depatureDate)
            ->setCabinClass($cabinClass)
            ->setAllocatedSeats($allocatedSeats)
            ->setOversellSeats($oversellSeats)
            ->setCurtailedSeats($curtailedSeats)
            ->setSeatsSold($seatsSold)
            ->setOnHoldSeats($onHoldSeats)
            ->setFixedSeats($fixedSeats)
            ->setAvailableSeats($availableSeats)
            ->setInfantAllocation($infantAllocation)
            ->setSoldInfantSeats($soldInfantSeats)
            ->setOnholdInfantSeats($onholdInfantSeats)
            ->setAvailableInfantSeats($availableInfantSeats)
            ->setSeatAllocations($seatAllocations);
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get depatureDate value
     * @return string|null
     */
    public function getDepatureDate()
    {
        return $this->depatureDate;
    }
    /**
     * Set depatureDate value
     * @param string $depatureDate
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setDepatureDate($depatureDate = null)
    {
        // validation for constraint: string
        if (!is_null($depatureDate) && !is_string($depatureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depatureDate)), __LINE__);
        }
        $this->depatureDate = $depatureDate;
        return $this;
    }
    /**
     * Get cabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->cabinClass;
    }
    /**
     * Set cabinClass value
     * @param string $cabinClass
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinClass)), __LINE__);
        }
        $this->cabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get allocatedSeats value
     * @return int|null
     */
    public function getAllocatedSeats()
    {
        return $this->allocatedSeats;
    }
    /**
     * Set allocatedSeats value
     * @param int $allocatedSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setAllocatedSeats($allocatedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedSeats) && !is_numeric($allocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allocatedSeats)), __LINE__);
        }
        $this->allocatedSeats = $allocatedSeats;
        return $this;
    }
    /**
     * Get oversellSeats value
     * @return int|null
     */
    public function getOversellSeats()
    {
        return $this->oversellSeats;
    }
    /**
     * Set oversellSeats value
     * @param int $oversellSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setOversellSeats($oversellSeats = null)
    {
        // validation for constraint: int
        if (!is_null($oversellSeats) && !is_numeric($oversellSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oversellSeats)), __LINE__);
        }
        $this->oversellSeats = $oversellSeats;
        return $this;
    }
    /**
     * Get curtailedSeats value
     * @return int|null
     */
    public function getCurtailedSeats()
    {
        return $this->curtailedSeats;
    }
    /**
     * Set curtailedSeats value
     * @param int $curtailedSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setCurtailedSeats($curtailedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($curtailedSeats) && !is_numeric($curtailedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($curtailedSeats)), __LINE__);
        }
        $this->curtailedSeats = $curtailedSeats;
        return $this;
    }
    /**
     * Get seatsSold value
     * @return int|null
     */
    public function getSeatsSold()
    {
        return $this->seatsSold;
    }
    /**
     * Set seatsSold value
     * @param int $seatsSold
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setSeatsSold($seatsSold = null)
    {
        // validation for constraint: int
        if (!is_null($seatsSold) && !is_numeric($seatsSold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsSold)), __LINE__);
        }
        $this->seatsSold = $seatsSold;
        return $this;
    }
    /**
     * Get onHoldSeats value
     * @return int|null
     */
    public function getOnHoldSeats()
    {
        return $this->onHoldSeats;
    }
    /**
     * Set onHoldSeats value
     * @param int $onHoldSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setOnHoldSeats($onHoldSeats = null)
    {
        // validation for constraint: int
        if (!is_null($onHoldSeats) && !is_numeric($onHoldSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onHoldSeats)), __LINE__);
        }
        $this->onHoldSeats = $onHoldSeats;
        return $this;
    }
    /**
     * Get fixedSeats value
     * @return int|null
     */
    public function getFixedSeats()
    {
        return $this->fixedSeats;
    }
    /**
     * Set fixedSeats value
     * @param int $fixedSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setFixedSeats($fixedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($fixedSeats) && !is_numeric($fixedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fixedSeats)), __LINE__);
        }
        $this->fixedSeats = $fixedSeats;
        return $this;
    }
    /**
     * Get availableSeats value
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return $this->availableSeats;
    }
    /**
     * Set availableSeats value
     * @param int $availableSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !is_numeric($availableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableSeats)), __LINE__);
        }
        $this->availableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get infantAllocation value
     * @return int|null
     */
    public function getInfantAllocation()
    {
        return $this->infantAllocation;
    }
    /**
     * Set infantAllocation value
     * @param int $infantAllocation
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setInfantAllocation($infantAllocation = null)
    {
        // validation for constraint: int
        if (!is_null($infantAllocation) && !is_numeric($infantAllocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infantAllocation)), __LINE__);
        }
        $this->infantAllocation = $infantAllocation;
        return $this;
    }
    /**
     * Get soldInfantSeats value
     * @return int|null
     */
    public function getSoldInfantSeats()
    {
        return $this->soldInfantSeats;
    }
    /**
     * Set soldInfantSeats value
     * @param int $soldInfantSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setSoldInfantSeats($soldInfantSeats = null)
    {
        // validation for constraint: int
        if (!is_null($soldInfantSeats) && !is_numeric($soldInfantSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($soldInfantSeats)), __LINE__);
        }
        $this->soldInfantSeats = $soldInfantSeats;
        return $this;
    }
    /**
     * Get onholdInfantSeats value
     * @return int|null
     */
    public function getOnholdInfantSeats()
    {
        return $this->onholdInfantSeats;
    }
    /**
     * Set onholdInfantSeats value
     * @param int $onholdInfantSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setOnholdInfantSeats($onholdInfantSeats = null)
    {
        // validation for constraint: int
        if (!is_null($onholdInfantSeats) && !is_numeric($onholdInfantSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onholdInfantSeats)), __LINE__);
        }
        $this->onholdInfantSeats = $onholdInfantSeats;
        return $this;
    }
    /**
     * Get availableInfantSeats value
     * @return int|null
     */
    public function getAvailableInfantSeats()
    {
        return $this->availableInfantSeats;
    }
    /**
     * Set availableInfantSeats value
     * @param int $availableInfantSeats
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setAvailableInfantSeats($availableInfantSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableInfantSeats) && !is_numeric($availableInfantSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableInfantSeats)), __LINE__);
        }
        $this->availableInfantSeats = $availableInfantSeats;
        return $this;
    }
    /**
     * Get seatAllocations value
     * @return \StructType\AASeatBCAllocationsType[]|null
     */
    public function getSeatAllocations()
    {
        return $this->seatAllocations;
    }
    /**
     * Set seatAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\AASeatBCAllocationsType[] $seatAllocations
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function setSeatAllocations(array $seatAllocations = array())
    {
        foreach ($seatAllocations as $aASegmentSeatInventoriesTypeSeatAllocationsItem) {
            // validation for constraint: itemType
            if (!$aASegmentSeatInventoriesTypeSeatAllocationsItem instanceof \StructType\AASeatBCAllocationsType) {
                throw new \InvalidArgumentException(sprintf('The seatAllocations property can only contain items of \StructType\AASeatBCAllocationsType, "%s" given', is_object($aASegmentSeatInventoriesTypeSeatAllocationsItem) ? get_class($aASegmentSeatInventoriesTypeSeatAllocationsItem) : gettype($aASegmentSeatInventoriesTypeSeatAllocationsItem)), __LINE__);
            }
        }
        $this->seatAllocations = $seatAllocations;
        return $this;
    }
    /**
     * Add item to seatAllocations value
     * @throws \InvalidArgumentException
     * @param \StructType\AASeatBCAllocationsType $item
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public function addToSeatAllocations(\StructType\AASeatBCAllocationsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AASeatBCAllocationsType) {
            throw new \InvalidArgumentException(sprintf('The seatAllocations property can only contain items of \StructType\AASeatBCAllocationsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->seatAllocations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AASegmentSeatInventoriesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
