<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AASegmentInventoryType StructType
 * @subpackage Structs
 */
class AASegmentInventoryType extends AbstractStructBase
{
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * The totalBoookings
     * @var int
     */
    public $totalBoookings;
    /**
     * The adultCount
     * @var int
     */
    public $adultCount;
    /**
     * The infantCount
     * @var int
     */
    public $infantCount;
    /**
     * The childCount
     * @var int
     */
    public $childCount;
    /**
     * Constructor method for AASegmentInventoryType
     * @uses AASegmentInventoryType::setSegmentCode()
     * @uses AASegmentInventoryType::setTotalBoookings()
     * @uses AASegmentInventoryType::setAdultCount()
     * @uses AASegmentInventoryType::setInfantCount()
     * @uses AASegmentInventoryType::setChildCount()
     * @param string $segmentCode
     * @param int $totalBoookings
     * @param int $adultCount
     * @param int $infantCount
     * @param int $childCount
     */
    public function __construct($segmentCode = null, $totalBoookings = null, $adultCount = null, $infantCount = null, $childCount = null)
    {
        $this
            ->setSegmentCode($segmentCode)
            ->setTotalBoookings($totalBoookings)
            ->setAdultCount($adultCount)
            ->setInfantCount($infantCount)
            ->setChildCount($childCount);
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AASegmentInventoryType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get totalBoookings value
     * @return int|null
     */
    public function getTotalBoookings()
    {
        return $this->totalBoookings;
    }
    /**
     * Set totalBoookings value
     * @param int $totalBoookings
     * @return \StructType\AASegmentInventoryType
     */
    public function setTotalBoookings($totalBoookings = null)
    {
        // validation for constraint: int
        if (!is_null($totalBoookings) && !is_numeric($totalBoookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalBoookings)), __LINE__);
        }
        $this->totalBoookings = $totalBoookings;
        return $this;
    }
    /**
     * Get adultCount value
     * @return int|null
     */
    public function getAdultCount()
    {
        return $this->adultCount;
    }
    /**
     * Set adultCount value
     * @param int $adultCount
     * @return \StructType\AASegmentInventoryType
     */
    public function setAdultCount($adultCount = null)
    {
        // validation for constraint: int
        if (!is_null($adultCount) && !is_numeric($adultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultCount)), __LINE__);
        }
        $this->adultCount = $adultCount;
        return $this;
    }
    /**
     * Get infantCount value
     * @return int|null
     */
    public function getInfantCount()
    {
        return $this->infantCount;
    }
    /**
     * Set infantCount value
     * @param int $infantCount
     * @return \StructType\AASegmentInventoryType
     */
    public function setInfantCount($infantCount = null)
    {
        // validation for constraint: int
        if (!is_null($infantCount) && !is_numeric($infantCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infantCount)), __LINE__);
        }
        $this->infantCount = $infantCount;
        return $this;
    }
    /**
     * Get childCount value
     * @return int|null
     */
    public function getChildCount()
    {
        return $this->childCount;
    }
    /**
     * Set childCount value
     * @param int $childCount
     * @return \StructType\AASegmentInventoryType
     */
    public function setChildCount($childCount = null)
    {
        // validation for constraint: int
        if (!is_null($childCount) && !is_numeric($childCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childCount)), __LINE__);
        }
        $this->childCount = $childCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AASegmentInventoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
