<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AASeatBCAllocationsType StructType
 * @subpackage Structs
 */
class AASeatBCAllocationsType extends AbstractStructBase
{
    /**
     * The bookingClass
     * @var string
     */
    public $bookingClass;
    /**
     * The seatsAllocated
     * @var int
     */
    public $seatsAllocated;
    /**
     * The seatsSold
     * @var int
     */
    public $seatsSold;
    /**
     * The onHoldSeats
     * @var int
     */
    public $onHoldSeats;
    /**
     * The seatsAvailable
     * @var int
     */
    public $seatsAvailable;
    /**
     * The seatsCancelled
     * @var int
     */
    public $seatsCancelled;
    /**
     * The seatsAcquired
     * @var int
     */
    public $seatsAcquired;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The priorityFlag
     * @var bool
     */
    public $priorityFlag;
    /**
     * The isStandardCode
     * @var bool
     */
    public $isStandardCode;
    /**
     * The isFixedFlag
     * @var bool
     */
    public $isFixedFlag;
    /**
     * The nestRank
     * @var int
     */
    public $nestRank;
    /**
     * The numOfAgents
     * @var int
     */
    public $numOfAgents;
    /**
     * The changeActionStatus
     * @var string
     */
    public $changeActionStatus;
    /**
     * The bcType
     * @var string
     */
    public $bcType;
    /**
     * The allocationType
     * @var string
     */
    public $allocationType;
    /**
     * The seatsSoldNestedIn
     * @var int
     */
    public $seatsSoldNestedIn;
    /**
     * The seatsSoldNestedOut
     * @var int
     */
    public $seatsSoldNestedOut;
    /**
     * The seatsOnHoldNestedIn
     * @var int
     */
    public $seatsOnHoldNestedIn;
    /**
     * The seatsOnHoldNestedOut
     * @var int
     */
    public $seatsOnHoldNestedOut;
    /**
     * The fareDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAFareType[]
     */
    public $fareDetails;
    /**
     * The surchargeApplicability
     * @var bool
     */
    public $surchargeApplicability;
    /**
     * Constructor method for AASeatBCAllocationsType
     * @uses AASeatBCAllocationsType::setBookingClass()
     * @uses AASeatBCAllocationsType::setSeatsAllocated()
     * @uses AASeatBCAllocationsType::setSeatsSold()
     * @uses AASeatBCAllocationsType::setOnHoldSeats()
     * @uses AASeatBCAllocationsType::setSeatsAvailable()
     * @uses AASeatBCAllocationsType::setSeatsCancelled()
     * @uses AASeatBCAllocationsType::setSeatsAcquired()
     * @uses AASeatBCAllocationsType::setStatus()
     * @uses AASeatBCAllocationsType::setPriorityFlag()
     * @uses AASeatBCAllocationsType::setIsStandardCode()
     * @uses AASeatBCAllocationsType::setIsFixedFlag()
     * @uses AASeatBCAllocationsType::setNestRank()
     * @uses AASeatBCAllocationsType::setNumOfAgents()
     * @uses AASeatBCAllocationsType::setChangeActionStatus()
     * @uses AASeatBCAllocationsType::setBcType()
     * @uses AASeatBCAllocationsType::setAllocationType()
     * @uses AASeatBCAllocationsType::setSeatsSoldNestedIn()
     * @uses AASeatBCAllocationsType::setSeatsSoldNestedOut()
     * @uses AASeatBCAllocationsType::setSeatsOnHoldNestedIn()
     * @uses AASeatBCAllocationsType::setSeatsOnHoldNestedOut()
     * @uses AASeatBCAllocationsType::setFareDetails()
     * @uses AASeatBCAllocationsType::setSurchargeApplicability()
     * @param string $bookingClass
     * @param int $seatsAllocated
     * @param int $seatsSold
     * @param int $onHoldSeats
     * @param int $seatsAvailable
     * @param int $seatsCancelled
     * @param int $seatsAcquired
     * @param string $status
     * @param bool $priorityFlag
     * @param bool $isStandardCode
     * @param bool $isFixedFlag
     * @param int $nestRank
     * @param int $numOfAgents
     * @param string $changeActionStatus
     * @param string $bcType
     * @param string $allocationType
     * @param int $seatsSoldNestedIn
     * @param int $seatsSoldNestedOut
     * @param int $seatsOnHoldNestedIn
     * @param int $seatsOnHoldNestedOut
     * @param \StructType\AAFareType[] $fareDetails
     * @param bool $surchargeApplicability
     */
    public function __construct($bookingClass = null, $seatsAllocated = null, $seatsSold = null, $onHoldSeats = null, $seatsAvailable = null, $seatsCancelled = null, $seatsAcquired = null, $status = null, $priorityFlag = null, $isStandardCode = null, $isFixedFlag = null, $nestRank = null, $numOfAgents = null, $changeActionStatus = null, $bcType = null, $allocationType = null, $seatsSoldNestedIn = null, $seatsSoldNestedOut = null, $seatsOnHoldNestedIn = null, $seatsOnHoldNestedOut = null, array $fareDetails = array(), $surchargeApplicability = null)
    {
        $this
            ->setBookingClass($bookingClass)
            ->setSeatsAllocated($seatsAllocated)
            ->setSeatsSold($seatsSold)
            ->setOnHoldSeats($onHoldSeats)
            ->setSeatsAvailable($seatsAvailable)
            ->setSeatsCancelled($seatsCancelled)
            ->setSeatsAcquired($seatsAcquired)
            ->setStatus($status)
            ->setPriorityFlag($priorityFlag)
            ->setIsStandardCode($isStandardCode)
            ->setIsFixedFlag($isFixedFlag)
            ->setNestRank($nestRank)
            ->setNumOfAgents($numOfAgents)
            ->setChangeActionStatus($changeActionStatus)
            ->setBcType($bcType)
            ->setAllocationType($allocationType)
            ->setSeatsSoldNestedIn($seatsSoldNestedIn)
            ->setSeatsSoldNestedOut($seatsSoldNestedOut)
            ->setSeatsOnHoldNestedIn($seatsOnHoldNestedIn)
            ->setSeatsOnHoldNestedOut($seatsOnHoldNestedOut)
            ->setFareDetails($fareDetails)
            ->setSurchargeApplicability($surchargeApplicability);
    }
    /**
     * Get bookingClass value
     * @return string|null
     */
    public function getBookingClass()
    {
        return $this->bookingClass;
    }
    /**
     * Set bookingClass value
     * @param string $bookingClass
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setBookingClass($bookingClass = null)
    {
        // validation for constraint: string
        if (!is_null($bookingClass) && !is_string($bookingClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingClass)), __LINE__);
        }
        $this->bookingClass = $bookingClass;
        return $this;
    }
    /**
     * Get seatsAllocated value
     * @return int|null
     */
    public function getSeatsAllocated()
    {
        return $this->seatsAllocated;
    }
    /**
     * Set seatsAllocated value
     * @param int $seatsAllocated
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsAllocated($seatsAllocated = null)
    {
        // validation for constraint: int
        if (!is_null($seatsAllocated) && !is_numeric($seatsAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsAllocated)), __LINE__);
        }
        $this->seatsAllocated = $seatsAllocated;
        return $this;
    }
    /**
     * Get seatsSold value
     * @return int|null
     */
    public function getSeatsSold()
    {
        return $this->seatsSold;
    }
    /**
     * Set seatsSold value
     * @param int $seatsSold
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsSold($seatsSold = null)
    {
        // validation for constraint: int
        if (!is_null($seatsSold) && !is_numeric($seatsSold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsSold)), __LINE__);
        }
        $this->seatsSold = $seatsSold;
        return $this;
    }
    /**
     * Get onHoldSeats value
     * @return int|null
     */
    public function getOnHoldSeats()
    {
        return $this->onHoldSeats;
    }
    /**
     * Set onHoldSeats value
     * @param int $onHoldSeats
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setOnHoldSeats($onHoldSeats = null)
    {
        // validation for constraint: int
        if (!is_null($onHoldSeats) && !is_numeric($onHoldSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onHoldSeats)), __LINE__);
        }
        $this->onHoldSeats = $onHoldSeats;
        return $this;
    }
    /**
     * Get seatsAvailable value
     * @return int|null
     */
    public function getSeatsAvailable()
    {
        return $this->seatsAvailable;
    }
    /**
     * Set seatsAvailable value
     * @param int $seatsAvailable
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsAvailable($seatsAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($seatsAvailable) && !is_numeric($seatsAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsAvailable)), __LINE__);
        }
        $this->seatsAvailable = $seatsAvailable;
        return $this;
    }
    /**
     * Get seatsCancelled value
     * @return int|null
     */
    public function getSeatsCancelled()
    {
        return $this->seatsCancelled;
    }
    /**
     * Set seatsCancelled value
     * @param int $seatsCancelled
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsCancelled($seatsCancelled = null)
    {
        // validation for constraint: int
        if (!is_null($seatsCancelled) && !is_numeric($seatsCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsCancelled)), __LINE__);
        }
        $this->seatsCancelled = $seatsCancelled;
        return $this;
    }
    /**
     * Get seatsAcquired value
     * @return int|null
     */
    public function getSeatsAcquired()
    {
        return $this->seatsAcquired;
    }
    /**
     * Set seatsAcquired value
     * @param int $seatsAcquired
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsAcquired($seatsAcquired = null)
    {
        // validation for constraint: int
        if (!is_null($seatsAcquired) && !is_numeric($seatsAcquired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsAcquired)), __LINE__);
        }
        $this->seatsAcquired = $seatsAcquired;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get priorityFlag value
     * @return bool|null
     */
    public function getPriorityFlag()
    {
        return $this->priorityFlag;
    }
    /**
     * Set priorityFlag value
     * @param bool $priorityFlag
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setPriorityFlag($priorityFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($priorityFlag) && !is_bool($priorityFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priorityFlag)), __LINE__);
        }
        $this->priorityFlag = $priorityFlag;
        return $this;
    }
    /**
     * Get isStandardCode value
     * @return bool|null
     */
    public function getIsStandardCode()
    {
        return $this->isStandardCode;
    }
    /**
     * Set isStandardCode value
     * @param bool $isStandardCode
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setIsStandardCode($isStandardCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStandardCode) && !is_bool($isStandardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isStandardCode)), __LINE__);
        }
        $this->isStandardCode = $isStandardCode;
        return $this;
    }
    /**
     * Get isFixedFlag value
     * @return bool|null
     */
    public function getIsFixedFlag()
    {
        return $this->isFixedFlag;
    }
    /**
     * Set isFixedFlag value
     * @param bool $isFixedFlag
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setIsFixedFlag($isFixedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFixedFlag) && !is_bool($isFixedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFixedFlag)), __LINE__);
        }
        $this->isFixedFlag = $isFixedFlag;
        return $this;
    }
    /**
     * Get nestRank value
     * @return int|null
     */
    public function getNestRank()
    {
        return $this->nestRank;
    }
    /**
     * Set nestRank value
     * @param int $nestRank
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setNestRank($nestRank = null)
    {
        // validation for constraint: int
        if (!is_null($nestRank) && !is_numeric($nestRank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nestRank)), __LINE__);
        }
        $this->nestRank = $nestRank;
        return $this;
    }
    /**
     * Get numOfAgents value
     * @return int|null
     */
    public function getNumOfAgents()
    {
        return $this->numOfAgents;
    }
    /**
     * Set numOfAgents value
     * @param int $numOfAgents
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setNumOfAgents($numOfAgents = null)
    {
        // validation for constraint: int
        if (!is_null($numOfAgents) && !is_numeric($numOfAgents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numOfAgents)), __LINE__);
        }
        $this->numOfAgents = $numOfAgents;
        return $this;
    }
    /**
     * Get changeActionStatus value
     * @return string|null
     */
    public function getChangeActionStatus()
    {
        return $this->changeActionStatus;
    }
    /**
     * Set changeActionStatus value
     * @param string $changeActionStatus
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setChangeActionStatus($changeActionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($changeActionStatus) && !is_string($changeActionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeActionStatus)), __LINE__);
        }
        $this->changeActionStatus = $changeActionStatus;
        return $this;
    }
    /**
     * Get bcType value
     * @return string|null
     */
    public function getBcType()
    {
        return $this->bcType;
    }
    /**
     * Set bcType value
     * @param string $bcType
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setBcType($bcType = null)
    {
        // validation for constraint: string
        if (!is_null($bcType) && !is_string($bcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bcType)), __LINE__);
        }
        $this->bcType = $bcType;
        return $this;
    }
    /**
     * Get allocationType value
     * @return string|null
     */
    public function getAllocationType()
    {
        return $this->allocationType;
    }
    /**
     * Set allocationType value
     * @param string $allocationType
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setAllocationType($allocationType = null)
    {
        // validation for constraint: string
        if (!is_null($allocationType) && !is_string($allocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allocationType)), __LINE__);
        }
        $this->allocationType = $allocationType;
        return $this;
    }
    /**
     * Get seatsSoldNestedIn value
     * @return int|null
     */
    public function getSeatsSoldNestedIn()
    {
        return $this->seatsSoldNestedIn;
    }
    /**
     * Set seatsSoldNestedIn value
     * @param int $seatsSoldNestedIn
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsSoldNestedIn($seatsSoldNestedIn = null)
    {
        // validation for constraint: int
        if (!is_null($seatsSoldNestedIn) && !is_numeric($seatsSoldNestedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsSoldNestedIn)), __LINE__);
        }
        $this->seatsSoldNestedIn = $seatsSoldNestedIn;
        return $this;
    }
    /**
     * Get seatsSoldNestedOut value
     * @return int|null
     */
    public function getSeatsSoldNestedOut()
    {
        return $this->seatsSoldNestedOut;
    }
    /**
     * Set seatsSoldNestedOut value
     * @param int $seatsSoldNestedOut
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsSoldNestedOut($seatsSoldNestedOut = null)
    {
        // validation for constraint: int
        if (!is_null($seatsSoldNestedOut) && !is_numeric($seatsSoldNestedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsSoldNestedOut)), __LINE__);
        }
        $this->seatsSoldNestedOut = $seatsSoldNestedOut;
        return $this;
    }
    /**
     * Get seatsOnHoldNestedIn value
     * @return int|null
     */
    public function getSeatsOnHoldNestedIn()
    {
        return $this->seatsOnHoldNestedIn;
    }
    /**
     * Set seatsOnHoldNestedIn value
     * @param int $seatsOnHoldNestedIn
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsOnHoldNestedIn($seatsOnHoldNestedIn = null)
    {
        // validation for constraint: int
        if (!is_null($seatsOnHoldNestedIn) && !is_numeric($seatsOnHoldNestedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsOnHoldNestedIn)), __LINE__);
        }
        $this->seatsOnHoldNestedIn = $seatsOnHoldNestedIn;
        return $this;
    }
    /**
     * Get seatsOnHoldNestedOut value
     * @return int|null
     */
    public function getSeatsOnHoldNestedOut()
    {
        return $this->seatsOnHoldNestedOut;
    }
    /**
     * Set seatsOnHoldNestedOut value
     * @param int $seatsOnHoldNestedOut
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSeatsOnHoldNestedOut($seatsOnHoldNestedOut = null)
    {
        // validation for constraint: int
        if (!is_null($seatsOnHoldNestedOut) && !is_numeric($seatsOnHoldNestedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seatsOnHoldNestedOut)), __LINE__);
        }
        $this->seatsOnHoldNestedOut = $seatsOnHoldNestedOut;
        return $this;
    }
    /**
     * Get fareDetails value
     * @return \StructType\AAFareType[]|null
     */
    public function getFareDetails()
    {
        return $this->fareDetails;
    }
    /**
     * Set fareDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\AAFareType[] $fareDetails
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setFareDetails(array $fareDetails = array())
    {
        foreach ($fareDetails as $aASeatBCAllocationsTypeFareDetailsItem) {
            // validation for constraint: itemType
            if (!$aASeatBCAllocationsTypeFareDetailsItem instanceof \StructType\AAFareType) {
                throw new \InvalidArgumentException(sprintf('The fareDetails property can only contain items of \StructType\AAFareType, "%s" given', is_object($aASeatBCAllocationsTypeFareDetailsItem) ? get_class($aASeatBCAllocationsTypeFareDetailsItem) : gettype($aASeatBCAllocationsTypeFareDetailsItem)), __LINE__);
            }
        }
        $this->fareDetails = $fareDetails;
        return $this;
    }
    /**
     * Add item to fareDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\AAFareType $item
     * @return \StructType\AASeatBCAllocationsType
     */
    public function addToFareDetails(\StructType\AAFareType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAFareType) {
            throw new \InvalidArgumentException(sprintf('The fareDetails property can only contain items of \StructType\AAFareType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->fareDetails[] = $item;
        return $this;
    }
    /**
     * Get surchargeApplicability value
     * @return bool|null
     */
    public function getSurchargeApplicability()
    {
        return $this->surchargeApplicability;
    }
    /**
     * Set surchargeApplicability value
     * @param bool $surchargeApplicability
     * @return \StructType\AASeatBCAllocationsType
     */
    public function setSurchargeApplicability($surchargeApplicability = null)
    {
        // validation for constraint: boolean
        if (!is_null($surchargeApplicability) && !is_bool($surchargeApplicability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($surchargeApplicability)), __LINE__);
        }
        $this->surchargeApplicability = $surchargeApplicability;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AASeatBCAllocationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
