<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAResAccSummaryType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reservation Account Summary (payments, balances and credits)
 * @subpackage Structs
 */
class AAResAccSummaryType extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - documentation: Total Price of the Reservation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPrice;
    /**
     * The TotalPaidAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total Payment Done for the Reservation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPaidAmount;
    /**
     * The TotalBalanceDue
     * Meta informations extracted from the WSDL
     * - documentation: Total Amount Due for the Reservation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalBalanceDue;
    /**
     * The TotalCreditAvailable
     * Meta informations extracted from the WSDL
     * - documentation: Total Credit Available in the Reservation
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalCreditAvailable;
    /**
     * The TravelersAccSummary
     * Meta informations extracted from the WSDL
     * - documentation: Traveler(PAX) wise Account Summary
     * - minOccurs: 0
     * @var \StructType\AATravelersAccSummaryType
     */
    public $TravelersAccSummary;
    /**
     * Constructor method for AAResAccSummaryType
     * @uses AAResAccSummaryType::setTotalPrice()
     * @uses AAResAccSummaryType::setTotalPaidAmount()
     * @uses AAResAccSummaryType::setTotalBalanceDue()
     * @uses AAResAccSummaryType::setTotalCreditAvailable()
     * @uses AAResAccSummaryType::setTravelersAccSummary()
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @param \StructType\AACurrencyAmountType $totalPaidAmount
     * @param \StructType\AACurrencyAmountType $totalBalanceDue
     * @param \StructType\AACurrencyAmountType $totalCreditAvailable
     * @param \StructType\AATravelersAccSummaryType $travelersAccSummary
     */
    public function __construct(\StructType\AACurrencyAmountType $totalPrice = null, \StructType\AACurrencyAmountType $totalPaidAmount = null, \StructType\AACurrencyAmountType $totalBalanceDue = null, \StructType\AACurrencyAmountType $totalCreditAvailable = null, \StructType\AATravelersAccSummaryType $travelersAccSummary = null)
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setTotalPaidAmount($totalPaidAmount)
            ->setTotalBalanceDue($totalBalanceDue)
            ->setTotalCreditAvailable($totalCreditAvailable)
            ->setTravelersAccSummary($travelersAccSummary);
    }
    /**
     * Get TotalPrice value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @return \StructType\AAResAccSummaryType
     */
    public function setTotalPrice(\StructType\AACurrencyAmountType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalPaidAmount value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPaidAmount()
    {
        return $this->TotalPaidAmount;
    }
    /**
     * Set TotalPaidAmount value
     * @param \StructType\AACurrencyAmountType $totalPaidAmount
     * @return \StructType\AAResAccSummaryType
     */
    public function setTotalPaidAmount(\StructType\AACurrencyAmountType $totalPaidAmount = null)
    {
        $this->TotalPaidAmount = $totalPaidAmount;
        return $this;
    }
    /**
     * Get TotalBalanceDue value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalBalanceDue()
    {
        return $this->TotalBalanceDue;
    }
    /**
     * Set TotalBalanceDue value
     * @param \StructType\AACurrencyAmountType $totalBalanceDue
     * @return \StructType\AAResAccSummaryType
     */
    public function setTotalBalanceDue(\StructType\AACurrencyAmountType $totalBalanceDue = null)
    {
        $this->TotalBalanceDue = $totalBalanceDue;
        return $this;
    }
    /**
     * Get TotalCreditAvailable value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalCreditAvailable()
    {
        return $this->TotalCreditAvailable;
    }
    /**
     * Set TotalCreditAvailable value
     * @param \StructType\AACurrencyAmountType $totalCreditAvailable
     * @return \StructType\AAResAccSummaryType
     */
    public function setTotalCreditAvailable(\StructType\AACurrencyAmountType $totalCreditAvailable = null)
    {
        $this->TotalCreditAvailable = $totalCreditAvailable;
        return $this;
    }
    /**
     * Get TravelersAccSummary value
     * @return \StructType\AATravelersAccSummaryType|null
     */
    public function getTravelersAccSummary()
    {
        return $this->TravelersAccSummary;
    }
    /**
     * Set TravelersAccSummary value
     * @param \StructType\AATravelersAccSummaryType $travelersAccSummary
     * @return \StructType\AAResAccSummaryType
     */
    public function setTravelersAccSummary(\StructType\AATravelersAccSummaryType $travelersAccSummary = null)
    {
        $this->TravelersAccSummary = $travelersAccSummary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAResAccSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
