<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPaxTypeCountSummaryType StructType
 * @subpackage Structs
 */
class AAPaxTypeCountSummaryType extends AbstractStructBase
{
    /**
     * The flightLegId
     * @var int
     */
    public $flightLegId;
    /**
     * The onholdPax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAPaxTypeCountDetailType[]
     */
    public $onholdPax;
    /**
     * The confirmedPax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAPaxTypeCountDetailType[]
     */
    public $confirmedPax;
    /**
     * Constructor method for AAPaxTypeCountSummaryType
     * @uses AAPaxTypeCountSummaryType::setFlightLegId()
     * @uses AAPaxTypeCountSummaryType::setOnholdPax()
     * @uses AAPaxTypeCountSummaryType::setConfirmedPax()
     * @param int $flightLegId
     * @param \StructType\AAPaxTypeCountDetailType[] $onholdPax
     * @param \StructType\AAPaxTypeCountDetailType[] $confirmedPax
     */
    public function __construct($flightLegId = null, array $onholdPax = array(), array $confirmedPax = array())
    {
        $this
            ->setFlightLegId($flightLegId)
            ->setOnholdPax($onholdPax)
            ->setConfirmedPax($confirmedPax);
    }
    /**
     * Get flightLegId value
     * @return int|null
     */
    public function getFlightLegId()
    {
        return $this->flightLegId;
    }
    /**
     * Set flightLegId value
     * @param int $flightLegId
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public function setFlightLegId($flightLegId = null)
    {
        // validation for constraint: int
        if (!is_null($flightLegId) && !is_numeric($flightLegId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flightLegId)), __LINE__);
        }
        $this->flightLegId = $flightLegId;
        return $this;
    }
    /**
     * Get onholdPax value
     * @return \StructType\AAPaxTypeCountDetailType[]|null
     */
    public function getOnholdPax()
    {
        return $this->onholdPax;
    }
    /**
     * Set onholdPax value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxTypeCountDetailType[] $onholdPax
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public function setOnholdPax(array $onholdPax = array())
    {
        foreach ($onholdPax as $aAPaxTypeCountSummaryTypeOnholdPaxItem) {
            // validation for constraint: itemType
            if (!$aAPaxTypeCountSummaryTypeOnholdPaxItem instanceof \StructType\AAPaxTypeCountDetailType) {
                throw new \InvalidArgumentException(sprintf('The onholdPax property can only contain items of \StructType\AAPaxTypeCountDetailType, "%s" given', is_object($aAPaxTypeCountSummaryTypeOnholdPaxItem) ? get_class($aAPaxTypeCountSummaryTypeOnholdPaxItem) : gettype($aAPaxTypeCountSummaryTypeOnholdPaxItem)), __LINE__);
            }
        }
        $this->onholdPax = $onholdPax;
        return $this;
    }
    /**
     * Add item to onholdPax value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxTypeCountDetailType $item
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public function addToOnholdPax(\StructType\AAPaxTypeCountDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPaxTypeCountDetailType) {
            throw new \InvalidArgumentException(sprintf('The onholdPax property can only contain items of \StructType\AAPaxTypeCountDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->onholdPax[] = $item;
        return $this;
    }
    /**
     * Get confirmedPax value
     * @return \StructType\AAPaxTypeCountDetailType[]|null
     */
    public function getConfirmedPax()
    {
        return $this->confirmedPax;
    }
    /**
     * Set confirmedPax value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxTypeCountDetailType[] $confirmedPax
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public function setConfirmedPax(array $confirmedPax = array())
    {
        foreach ($confirmedPax as $aAPaxTypeCountSummaryTypeConfirmedPaxItem) {
            // validation for constraint: itemType
            if (!$aAPaxTypeCountSummaryTypeConfirmedPaxItem instanceof \StructType\AAPaxTypeCountDetailType) {
                throw new \InvalidArgumentException(sprintf('The confirmedPax property can only contain items of \StructType\AAPaxTypeCountDetailType, "%s" given', is_object($aAPaxTypeCountSummaryTypeConfirmedPaxItem) ? get_class($aAPaxTypeCountSummaryTypeConfirmedPaxItem) : gettype($aAPaxTypeCountSummaryTypeConfirmedPaxItem)), __LINE__);
            }
        }
        $this->confirmedPax = $confirmedPax;
        return $this;
    }
    /**
     * Add item to confirmedPax value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxTypeCountDetailType $item
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public function addToConfirmedPax(\StructType\AAPaxTypeCountDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPaxTypeCountDetailType) {
            throw new \InvalidArgumentException(sprintf('The confirmedPax property can only contain items of \StructType\AAPaxTypeCountDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->confirmedPax[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPaxTypeCountSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
