<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPaxTypeCountDetailType StructType
 * @subpackage Structs
 */
class AAPaxTypeCountDetailType extends AbstractStructBase
{
    /**
     * The adultMaleCount
     * @var int
     */
    public $adultMaleCount;
    /**
     * The adultFemaleCount
     * @var int
     */
    public $adultFemaleCount;
    /**
     * The infantCount
     * @var int
     */
    public $infantCount;
    /**
     * The childCount
     * @var int
     */
    public $childCount;
    /**
     * The otherCount
     * @var int
     */
    public $otherCount;
    /**
     * Constructor method for AAPaxTypeCountDetailType
     * @uses AAPaxTypeCountDetailType::setAdultMaleCount()
     * @uses AAPaxTypeCountDetailType::setAdultFemaleCount()
     * @uses AAPaxTypeCountDetailType::setInfantCount()
     * @uses AAPaxTypeCountDetailType::setChildCount()
     * @uses AAPaxTypeCountDetailType::setOtherCount()
     * @param int $adultMaleCount
     * @param int $adultFemaleCount
     * @param int $infantCount
     * @param int $childCount
     * @param int $otherCount
     */
    public function __construct($adultMaleCount = null, $adultFemaleCount = null, $infantCount = null, $childCount = null, $otherCount = null)
    {
        $this
            ->setAdultMaleCount($adultMaleCount)
            ->setAdultFemaleCount($adultFemaleCount)
            ->setInfantCount($infantCount)
            ->setChildCount($childCount)
            ->setOtherCount($otherCount);
    }
    /**
     * Get adultMaleCount value
     * @return int|null
     */
    public function getAdultMaleCount()
    {
        return $this->adultMaleCount;
    }
    /**
     * Set adultMaleCount value
     * @param int $adultMaleCount
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public function setAdultMaleCount($adultMaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($adultMaleCount) && !is_numeric($adultMaleCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultMaleCount)), __LINE__);
        }
        $this->adultMaleCount = $adultMaleCount;
        return $this;
    }
    /**
     * Get adultFemaleCount value
     * @return int|null
     */
    public function getAdultFemaleCount()
    {
        return $this->adultFemaleCount;
    }
    /**
     * Set adultFemaleCount value
     * @param int $adultFemaleCount
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public function setAdultFemaleCount($adultFemaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($adultFemaleCount) && !is_numeric($adultFemaleCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultFemaleCount)), __LINE__);
        }
        $this->adultFemaleCount = $adultFemaleCount;
        return $this;
    }
    /**
     * Get infantCount value
     * @return int|null
     */
    public function getInfantCount()
    {
        return $this->infantCount;
    }
    /**
     * Set infantCount value
     * @param int $infantCount
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public function setInfantCount($infantCount = null)
    {
        // validation for constraint: int
        if (!is_null($infantCount) && !is_numeric($infantCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infantCount)), __LINE__);
        }
        $this->infantCount = $infantCount;
        return $this;
    }
    /**
     * Get childCount value
     * @return int|null
     */
    public function getChildCount()
    {
        return $this->childCount;
    }
    /**
     * Set childCount value
     * @param int $childCount
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public function setChildCount($childCount = null)
    {
        // validation for constraint: int
        if (!is_null($childCount) && !is_numeric($childCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childCount)), __LINE__);
        }
        $this->childCount = $childCount;
        return $this;
    }
    /**
     * Get otherCount value
     * @return int|null
     */
    public function getOtherCount()
    {
        return $this->otherCount;
    }
    /**
     * Set otherCount value
     * @param int $otherCount
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public function setOtherCount($otherCount = null)
    {
        // validation for constraint: int
        if (!is_null($otherCount) && !is_numeric($otherCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherCount)), __LINE__);
        }
        $this->otherCount = $otherCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPaxTypeCountDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
