<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPaxCreditType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Pax credit information.
 * @subpackage Structs
 */
class AAPaxCreditType extends AbstractStructBase
{
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The CreditAmount
     * @var \StructType\CreditAmount
     */
    public $CreditAmount;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: Uniquely identifies pax credit record
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AAPaxCreditType
     * @uses AAPaxCreditType::setFirstName()
     * @uses AAPaxCreditType::setLastName()
     * @uses AAPaxCreditType::setCreditAmount()
     * @uses AAPaxCreditType::setRPH()
     * @param string $firstName
     * @param string $lastName
     * @param \StructType\CreditAmount $creditAmount
     * @param string $rPH
     */
    public function __construct($firstName = null, $lastName = null, \StructType\CreditAmount $creditAmount = null, $rPH = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCreditAmount($creditAmount)
            ->setRPH($rPH);
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AAPaxCreditType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AAPaxCreditType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get CreditAmount value
     * @return \StructType\CreditAmount|null
     */
    public function getCreditAmount()
    {
        return $this->CreditAmount;
    }
    /**
     * Set CreditAmount value
     * @param \StructType\CreditAmount $creditAmount
     * @return \StructType\AAPaxCreditType
     */
    public function setCreditAmount(\StructType\CreditAmount $creditAmount = null)
    {
        $this->CreditAmount = $creditAmount;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AAPaxCreditType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPaxCreditType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
