<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPaxCreditReadRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Captures criteria for loading pax credit.
 * @subpackage Structs
 */
class AAPaxCreditReadRequestType extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The FromAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FromAirport
     */
    public $FromAirport;
    /**
     * The ToAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ToAirport
     */
    public $ToAirport;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TelephoneNumber;
    /**
     * The CreditCardNumber
     * Meta informations extracted from the WSDL
     * - documentation: Last 4 digits of credit card number | Used for Numeric Strings, length 4.
     * - minOccurs: 0
     * - pattern: [0-9]{4}
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - documentation: Expiry Date in (MM/YY) format | Month and year information.
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $ExpiryDate;
    /**
     * The exactMatchOnly
     * Meta informations extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $exactMatchOnly;
    /**
     * The excludeZeroBalanceRecords
     * Meta informations extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $excludeZeroBalanceRecords;
    /**
     * Constructor method for AAPaxCreditReadRequestType
     * @uses AAPaxCreditReadRequestType::setFirstName()
     * @uses AAPaxCreditReadRequestType::setLastName()
     * @uses AAPaxCreditReadRequestType::setBookingReferenceID()
     * @uses AAPaxCreditReadRequestType::setFromAirport()
     * @uses AAPaxCreditReadRequestType::setToAirport()
     * @uses AAPaxCreditReadRequestType::setDepartureDateTime()
     * @uses AAPaxCreditReadRequestType::setArrivalDateTime()
     * @uses AAPaxCreditReadRequestType::setFlightNumber()
     * @uses AAPaxCreditReadRequestType::setTelephoneNumber()
     * @uses AAPaxCreditReadRequestType::setCreditCardNumber()
     * @uses AAPaxCreditReadRequestType::setExpiryDate()
     * @uses AAPaxCreditReadRequestType::setExactMatchOnly()
     * @uses AAPaxCreditReadRequestType::setExcludeZeroBalanceRecords()
     * @param string $firstName
     * @param string $lastName
     * @param string $bookingReferenceID
     * @param \StructType\FromAirport $fromAirport
     * @param \StructType\ToAirport $toAirport
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $flightNumber
     * @param string $telephoneNumber
     * @param string $creditCardNumber
     * @param string $expiryDate
     * @param bool $exactMatchOnly
     * @param bool $excludeZeroBalanceRecords
     */
    public function __construct($firstName = null, $lastName = null, $bookingReferenceID = null, \StructType\FromAirport $fromAirport = null, \StructType\ToAirport $toAirport = null, $departureDateTime = null, $arrivalDateTime = null, $flightNumber = null, $telephoneNumber = null, $creditCardNumber = null, $expiryDate = null, $exactMatchOnly = true, $excludeZeroBalanceRecords = true)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setBookingReferenceID($bookingReferenceID)
            ->setFromAirport($fromAirport)
            ->setToAirport($toAirport)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFlightNumber($flightNumber)
            ->setTelephoneNumber($telephoneNumber)
            ->setCreditCardNumber($creditCardNumber)
            ->setExpiryDate($expiryDate)
            ->setExactMatchOnly($exactMatchOnly)
            ->setExcludeZeroBalanceRecords($excludeZeroBalanceRecords);
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get FromAirport value
     * @return \StructType\FromAirport|null
     */
    public function getFromAirport()
    {
        return $this->FromAirport;
    }
    /**
     * Set FromAirport value
     * @param \StructType\FromAirport $fromAirport
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setFromAirport(\StructType\FromAirport $fromAirport = null)
    {
        $this->FromAirport = $fromAirport;
        return $this;
    }
    /**
     * Get ToAirport value
     * @return \StructType\ToAirport|null
     */
    public function getToAirport()
    {
        return $this->ToAirport;
    }
    /**
     * Set ToAirport value
     * @param \StructType\ToAirport $toAirport
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setToAirport(\StructType\ToAirport $toAirport = null)
    {
        $this->ToAirport = $toAirport;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($creditCardNumber) && !preg_match('/[0-9]{4}/', $creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{4}", "%s" given', var_export($creditCardNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($expiryDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(0[1-9]|1[0-2])[0-9][0-9]", "%s" given', var_export($expiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get exactMatchOnly value
     * @return bool|null
     */
    public function getExactMatchOnly()
    {
        return $this->exactMatchOnly;
    }
    /**
     * Set exactMatchOnly value
     * @param bool $exactMatchOnly
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setExactMatchOnly($exactMatchOnly = true)
    {
        // validation for constraint: boolean
        if (!is_null($exactMatchOnly) && !is_bool($exactMatchOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exactMatchOnly)), __LINE__);
        }
        $this->exactMatchOnly = $exactMatchOnly;
        return $this;
    }
    /**
     * Get excludeZeroBalanceRecords value
     * @return bool|null
     */
    public function getExcludeZeroBalanceRecords()
    {
        return $this->excludeZeroBalanceRecords;
    }
    /**
     * Set excludeZeroBalanceRecords value
     * @param bool $excludeZeroBalanceRecords
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public function setExcludeZeroBalanceRecords($excludeZeroBalanceRecords = true)
    {
        // validation for constraint: boolean
        if (!is_null($excludeZeroBalanceRecords) && !is_bool($excludeZeroBalanceRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeZeroBalanceRecords)), __LINE__);
        }
        $this->excludeZeroBalanceRecords = $excludeZeroBalanceRecords;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPaxCreditReadRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
