<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPTCCountsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Passenger Type counts.
 * @subpackage Structs
 */
class AAPTCCountsType extends AbstractStructBase
{
    /**
     * The PTCCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\AAPTCCountType[]
     */
    public $PTCCount;
    /**
     * Constructor method for AAPTCCountsType
     * @uses AAPTCCountsType::setPTCCount()
     * @param \StructType\AAPTCCountType[] $pTCCount
     */
    public function __construct(array $pTCCount = array())
    {
        $this
            ->setPTCCount($pTCCount);
    }
    /**
     * Get PTCCount value
     * @return \StructType\AAPTCCountType[]|null
     */
    public function getPTCCount()
    {
        return $this->PTCCount;
    }
    /**
     * Set PTCCount value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPTCCountType[] $pTCCount
     * @return \StructType\AAPTCCountsType
     */
    public function setPTCCount(array $pTCCount = array())
    {
        foreach ($pTCCount as $aAPTCCountsTypePTCCountItem) {
            // validation for constraint: itemType
            if (!$aAPTCCountsTypePTCCountItem instanceof \StructType\AAPTCCountType) {
                throw new \InvalidArgumentException(sprintf('The PTCCount property can only contain items of \StructType\AAPTCCountType, "%s" given', is_object($aAPTCCountsTypePTCCountItem) ? get_class($aAPTCCountsTypePTCCountItem) : gettype($aAPTCCountsTypePTCCountItem)), __LINE__);
            }
        }
        $this->PTCCount = $pTCCount;
        return $this;
    }
    /**
     * Add item to PTCCount value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPTCCountType $item
     * @return \StructType\AAPTCCountsType
     */
    public function addToPTCCount(\StructType\AAPTCCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPTCCountType) {
            throw new \InvalidArgumentException(sprintf('The PTCCount property can only contain items of \StructType\AAPTCCountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PTCCount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPTCCountsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
