<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRPaymentTransactionType StructType
 * @subpackage Structs
 */
class AAPNRPaymentTransactionType extends AbstractStructBase
{
    /**
     * The PNRNo
     * @var string
     */
    public $PNRNo;
    /**
     * The PaymentTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentTransaction[]
     */
    public $PaymentTransaction;
    /**
     * Constructor method for AAPNRPaymentTransactionType
     * @uses AAPNRPaymentTransactionType::setPNRNo()
     * @uses AAPNRPaymentTransactionType::setPaymentTransaction()
     * @param string $pNRNo
     * @param \StructType\PaymentTransaction[] $paymentTransaction
     */
    public function __construct($pNRNo = null, array $paymentTransaction = array())
    {
        $this
            ->setPNRNo($pNRNo)
            ->setPaymentTransaction($paymentTransaction);
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \StructType\AAPNRPaymentTransactionType
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get PaymentTransaction value
     * @return \StructType\PaymentTransaction[]|null
     */
    public function getPaymentTransaction()
    {
        return $this->PaymentTransaction;
    }
    /**
     * Set PaymentTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentTransaction[] $paymentTransaction
     * @return \StructType\AAPNRPaymentTransactionType
     */
    public function setPaymentTransaction(array $paymentTransaction = array())
    {
        foreach ($paymentTransaction as $aAPNRPaymentTransactionTypePaymentTransactionItem) {
            // validation for constraint: itemType
            if (!$aAPNRPaymentTransactionTypePaymentTransactionItem instanceof \StructType\PaymentTransaction) {
                throw new \InvalidArgumentException(sprintf('The PaymentTransaction property can only contain items of \StructType\PaymentTransaction, "%s" given', is_object($aAPNRPaymentTransactionTypePaymentTransactionItem) ? get_class($aAPNRPaymentTransactionTypePaymentTransactionItem) : gettype($aAPNRPaymentTransactionTypePaymentTransactionItem)), __LINE__);
            }
        }
        $this->PaymentTransaction = $paymentTransaction;
        return $this;
    }
    /**
     * Add item to PaymentTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentTransaction $item
     * @return \StructType\AAPNRPaymentTransactionType
     */
    public function addToPaymentTransaction(\StructType\PaymentTransaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentTransaction) {
            throw new \InvalidArgumentException(sprintf('The PaymentTransaction property can only contain items of \StructType\PaymentTransaction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentTransaction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRPaymentTransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
