<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRPaxTransactionsType StructType
 * @subpackage Structs
 */
class AAPNRPaxTransactionsType extends AbstractStructBase
{
    /**
     * The paxTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AAPNRPaxTransactionType[]
     */
    public $paxTransaction;
    /**
     * Constructor method for AAPNRPaxTransactionsType
     * @uses AAPNRPaxTransactionsType::setPaxTransaction()
     * @param \StructType\AAPNRPaxTransactionType[] $paxTransaction
     */
    public function __construct(array $paxTransaction = array())
    {
        $this
            ->setPaxTransaction($paxTransaction);
    }
    /**
     * Get paxTransaction value
     * @return \StructType\AAPNRPaxTransactionType[]|null
     */
    public function getPaxTransaction()
    {
        return $this->paxTransaction;
    }
    /**
     * Set paxTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRPaxTransactionType[] $paxTransaction
     * @return \StructType\AAPNRPaxTransactionsType
     */
    public function setPaxTransaction(array $paxTransaction = array())
    {
        foreach ($paxTransaction as $aAPNRPaxTransactionsTypePaxTransactionItem) {
            // validation for constraint: itemType
            if (!$aAPNRPaxTransactionsTypePaxTransactionItem instanceof \StructType\AAPNRPaxTransactionType) {
                throw new \InvalidArgumentException(sprintf('The paxTransaction property can only contain items of \StructType\AAPNRPaxTransactionType, "%s" given', is_object($aAPNRPaxTransactionsTypePaxTransactionItem) ? get_class($aAPNRPaxTransactionsTypePaxTransactionItem) : gettype($aAPNRPaxTransactionsTypePaxTransactionItem)), __LINE__);
            }
        }
        $this->paxTransaction = $paxTransaction;
        return $this;
    }
    /**
     * Add item to paxTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRPaxTransactionType $item
     * @return \StructType\AAPNRPaxTransactionsType
     */
    public function addToPaxTransaction(\StructType\AAPNRPaxTransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPNRPaxTransactionType) {
            throw new \InvalidArgumentException(sprintf('The paxTransaction property can only contain items of \StructType\AAPNRPaxTransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paxTransaction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRPaxTransactionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
