<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRPaxTicketingDataType StructType
 * @subpackage Structs
 */
class AAPNRPaxTicketingDataType extends AbstractStructBase
{
    /**
     * The pnr
     * @var string
     */
    public $pnr;
    /**
     * The airlineCode
     * @var string
     */
    public $airlineCode;
    /**
     * The firstTravelDate
     * @var string
     */
    public $firstTravelDate;
    /**
     * The routing
     * @var string
     */
    public $routing;
    /**
     * The pax
     * @var \StructType\Pax
     */
    public $pax;
    /**
     * The pnrFlightSegments
     * @var \StructType\AAPNRFlightSegmentsType
     */
    public $pnrFlightSegments;
    /**
     * The paxTransactions
     * @var \StructType\AAPNRPaxTransactionsType
     */
    public $paxTransactions;
    /**
     * The paxSegsPricing
     * @var \StructType\AAPNRPaxSegsPricingType
     */
    public $paxSegsPricing;
    /**
     * Constructor method for AAPNRPaxTicketingDataType
     * @uses AAPNRPaxTicketingDataType::setPnr()
     * @uses AAPNRPaxTicketingDataType::setAirlineCode()
     * @uses AAPNRPaxTicketingDataType::setFirstTravelDate()
     * @uses AAPNRPaxTicketingDataType::setRouting()
     * @uses AAPNRPaxTicketingDataType::setPax()
     * @uses AAPNRPaxTicketingDataType::setPnrFlightSegments()
     * @uses AAPNRPaxTicketingDataType::setPaxTransactions()
     * @uses AAPNRPaxTicketingDataType::setPaxSegsPricing()
     * @param string $pnr
     * @param string $airlineCode
     * @param string $firstTravelDate
     * @param string $routing
     * @param \StructType\Pax $pax
     * @param \StructType\AAPNRFlightSegmentsType $pnrFlightSegments
     * @param \StructType\AAPNRPaxTransactionsType $paxTransactions
     * @param \StructType\AAPNRPaxSegsPricingType $paxSegsPricing
     */
    public function __construct($pnr = null, $airlineCode = null, $firstTravelDate = null, $routing = null, \StructType\Pax $pax = null, \StructType\AAPNRFlightSegmentsType $pnrFlightSegments = null, \StructType\AAPNRPaxTransactionsType $paxTransactions = null, \StructType\AAPNRPaxSegsPricingType $paxSegsPricing = null)
    {
        $this
            ->setPnr($pnr)
            ->setAirlineCode($airlineCode)
            ->setFirstTravelDate($firstTravelDate)
            ->setRouting($routing)
            ->setPax($pax)
            ->setPnrFlightSegments($pnrFlightSegments)
            ->setPaxTransactions($paxTransactions)
            ->setPaxSegsPricing($paxSegsPricing);
    }
    /**
     * Get pnr value
     * @return string|null
     */
    public function getPnr()
    {
        return $this->pnr;
    }
    /**
     * Set pnr value
     * @param string $pnr
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setPnr($pnr = null)
    {
        // validation for constraint: string
        if (!is_null($pnr) && !is_string($pnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pnr)), __LINE__);
        }
        $this->pnr = $pnr;
        return $this;
    }
    /**
     * Get airlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->airlineCode;
    }
    /**
     * Set airlineCode value
     * @param string $airlineCode
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->airlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get firstTravelDate value
     * @return string|null
     */
    public function getFirstTravelDate()
    {
        return $this->firstTravelDate;
    }
    /**
     * Set firstTravelDate value
     * @param string $firstTravelDate
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setFirstTravelDate($firstTravelDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstTravelDate) && !is_string($firstTravelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstTravelDate)), __LINE__);
        }
        $this->firstTravelDate = $firstTravelDate;
        return $this;
    }
    /**
     * Get routing value
     * @return string|null
     */
    public function getRouting()
    {
        return $this->routing;
    }
    /**
     * Set routing value
     * @param string $routing
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setRouting($routing = null)
    {
        // validation for constraint: string
        if (!is_null($routing) && !is_string($routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routing)), __LINE__);
        }
        $this->routing = $routing;
        return $this;
    }
    /**
     * Get pax value
     * @return \StructType\Pax|null
     */
    public function getPax()
    {
        return $this->pax;
    }
    /**
     * Set pax value
     * @param \StructType\Pax $pax
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setPax(\StructType\Pax $pax = null)
    {
        $this->pax = $pax;
        return $this;
    }
    /**
     * Get pnrFlightSegments value
     * @return \StructType\AAPNRFlightSegmentsType|null
     */
    public function getPnrFlightSegments()
    {
        return $this->pnrFlightSegments;
    }
    /**
     * Set pnrFlightSegments value
     * @param \StructType\AAPNRFlightSegmentsType $pnrFlightSegments
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setPnrFlightSegments(\StructType\AAPNRFlightSegmentsType $pnrFlightSegments = null)
    {
        $this->pnrFlightSegments = $pnrFlightSegments;
        return $this;
    }
    /**
     * Get paxTransactions value
     * @return \StructType\AAPNRPaxTransactionsType|null
     */
    public function getPaxTransactions()
    {
        return $this->paxTransactions;
    }
    /**
     * Set paxTransactions value
     * @param \StructType\AAPNRPaxTransactionsType $paxTransactions
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setPaxTransactions(\StructType\AAPNRPaxTransactionsType $paxTransactions = null)
    {
        $this->paxTransactions = $paxTransactions;
        return $this;
    }
    /**
     * Get paxSegsPricing value
     * @return \StructType\AAPNRPaxSegsPricingType|null
     */
    public function getPaxSegsPricing()
    {
        return $this->paxSegsPricing;
    }
    /**
     * Set paxSegsPricing value
     * @param \StructType\AAPNRPaxSegsPricingType $paxSegsPricing
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public function setPaxSegsPricing(\StructType\AAPNRPaxSegsPricingType $paxSegsPricing = null)
    {
        $this->paxSegsPricing = $paxSegsPricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRPaxTicketingDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
