<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRPaxSegPricingType StructType
 * @subpackage Structs
 */
class AAPNRPaxSegPricingType extends AbstractStructBase
{
    /**
     * The fare
     * @var \StructType\Fare_1
     */
    public $fare;
    /**
     * The taxes
     * @var \StructType\AATaxesType
     */
    public $taxes;
    /**
     * The fees
     * @var \StructType\AAFeesType
     */
    public $fees;
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * Constructor method for AAPNRPaxSegPricingType
     * @uses AAPNRPaxSegPricingType::setFare()
     * @uses AAPNRPaxSegPricingType::setTaxes()
     * @uses AAPNRPaxSegPricingType::setFees()
     * @uses AAPNRPaxSegPricingType::setSegmentCode()
     * @param \StructType\Fare_1 $fare
     * @param \StructType\AATaxesType $taxes
     * @param \StructType\AAFeesType $fees
     * @param string $segmentCode
     */
    public function __construct(\StructType\Fare_1 $fare = null, \StructType\AATaxesType $taxes = null, \StructType\AAFeesType $fees = null, $segmentCode = null)
    {
        $this
            ->setFare($fare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setSegmentCode($segmentCode);
    }
    /**
     * Get fare value
     * @return \StructType\Fare_1|null
     */
    public function getFare()
    {
        return $this->fare;
    }
    /**
     * Set fare value
     * @param \StructType\Fare_1 $fare
     * @return \StructType\AAPNRPaxSegPricingType
     */
    public function setFare(\StructType\Fare_1 $fare = null)
    {
        $this->fare = $fare;
        return $this;
    }
    /**
     * Get taxes value
     * @return \StructType\AATaxesType|null
     */
    public function getTaxes()
    {
        return $this->taxes;
    }
    /**
     * Set taxes value
     * @param \StructType\AATaxesType $taxes
     * @return \StructType\AAPNRPaxSegPricingType
     */
    public function setTaxes(\StructType\AATaxesType $taxes = null)
    {
        $this->taxes = $taxes;
        return $this;
    }
    /**
     * Get fees value
     * @return \StructType\AAFeesType|null
     */
    public function getFees()
    {
        return $this->fees;
    }
    /**
     * Set fees value
     * @param \StructType\AAFeesType $fees
     * @return \StructType\AAPNRPaxSegPricingType
     */
    public function setFees(\StructType\AAFeesType $fees = null)
    {
        $this->fees = $fees;
        return $this;
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AAPNRPaxSegPricingType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRPaxSegPricingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
