<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRAuditMessageType StructType
 * Meta informations extracted from the WSDL
 * - documentation: A Reservation Audit Message
 * @subpackage Structs
 */
class AAPNRAuditMessageType extends AbstractStructBase
{
    /**
     * The zuluTimestamp
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $zuluTimestamp;
    /**
     * The userID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $userID;
    /**
     * The auditType
     * @var \StructType\AAAuditType
     */
    public $auditType;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The userNoteText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userNoteText;
    /**
     * Constructor method for AAPNRAuditMessageType
     * @uses AAPNRAuditMessageType::setZuluTimestamp()
     * @uses AAPNRAuditMessageType::setUserID()
     * @uses AAPNRAuditMessageType::setAuditType()
     * @uses AAPNRAuditMessageType::setDescription()
     * @uses AAPNRAuditMessageType::setUserNoteText()
     * @param string $zuluTimestamp
     * @param string $userID
     * @param \StructType\AAAuditType $auditType
     * @param string $description
     * @param string $userNoteText
     */
    public function __construct($zuluTimestamp = null, $userID = null, \StructType\AAAuditType $auditType = null, $description = null, $userNoteText = null)
    {
        $this
            ->setZuluTimestamp($zuluTimestamp)
            ->setUserID($userID)
            ->setAuditType($auditType)
            ->setDescription($description)
            ->setUserNoteText($userNoteText);
    }
    /**
     * Get zuluTimestamp value
     * @return string
     */
    public function getZuluTimestamp()
    {
        return $this->zuluTimestamp;
    }
    /**
     * Set zuluTimestamp value
     * @param string $zuluTimestamp
     * @return \StructType\AAPNRAuditMessageType
     */
    public function setZuluTimestamp($zuluTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($zuluTimestamp) && !is_string($zuluTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zuluTimestamp)), __LINE__);
        }
        $this->zuluTimestamp = $zuluTimestamp;
        return $this;
    }
    /**
     * Get userID value
     * @return string
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\AAPNRAuditMessageType
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get auditType value
     * @return \StructType\AAAuditType|null
     */
    public function getAuditType()
    {
        return $this->auditType;
    }
    /**
     * Set auditType value
     * @param \StructType\AAAuditType $auditType
     * @return \StructType\AAPNRAuditMessageType
     */
    public function setAuditType(\StructType\AAAuditType $auditType = null)
    {
        $this->auditType = $auditType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AAPNRAuditMessageType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userNoteText value
     * @return string|null
     */
    public function getUserNoteText()
    {
        return $this->userNoteText;
    }
    /**
     * Set userNoteText value
     * @param string $userNoteText
     * @return \StructType\AAPNRAuditMessageType
     */
    public function setUserNoteText($userNoteText = null)
    {
        // validation for constraint: string
        if (!is_null($userNoteText) && !is_string($userNoteText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userNoteText)), __LINE__);
        }
        $this->userNoteText = $userNoteText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRAuditMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
