<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAInventorySeatMovementType StructType
 * @subpackage Structs
 */
class AAInventorySeatMovementType extends AbstractStructBase
{
    /**
     * The fromBookingClass
     * @var string
     */
    public $fromBookingClass;
    /**
     * The toBookingClass
     * @var string
     */
    public $toBookingClass;
    /**
     * The noOfSeats
     * @var int
     */
    public $noOfSeats;
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - documentation: abcd
     * @var string
     */
    public $messageType;
    /**
     * Constructor method for AAInventorySeatMovementType
     * @uses AAInventorySeatMovementType::setFromBookingClass()
     * @uses AAInventorySeatMovementType::setToBookingClass()
     * @uses AAInventorySeatMovementType::setNoOfSeats()
     * @uses AAInventorySeatMovementType::setMessageType()
     * @param string $fromBookingClass
     * @param string $toBookingClass
     * @param int $noOfSeats
     * @param string $messageType
     */
    public function __construct($fromBookingClass = null, $toBookingClass = null, $noOfSeats = null, $messageType = null)
    {
        $this
            ->setFromBookingClass($fromBookingClass)
            ->setToBookingClass($toBookingClass)
            ->setNoOfSeats($noOfSeats)
            ->setMessageType($messageType);
    }
    /**
     * Get fromBookingClass value
     * @return string|null
     */
    public function getFromBookingClass()
    {
        return $this->fromBookingClass;
    }
    /**
     * Set fromBookingClass value
     * @param string $fromBookingClass
     * @return \StructType\AAInventorySeatMovementType
     */
    public function setFromBookingClass($fromBookingClass = null)
    {
        // validation for constraint: string
        if (!is_null($fromBookingClass) && !is_string($fromBookingClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromBookingClass)), __LINE__);
        }
        $this->fromBookingClass = $fromBookingClass;
        return $this;
    }
    /**
     * Get toBookingClass value
     * @return string|null
     */
    public function getToBookingClass()
    {
        return $this->toBookingClass;
    }
    /**
     * Set toBookingClass value
     * @param string $toBookingClass
     * @return \StructType\AAInventorySeatMovementType
     */
    public function setToBookingClass($toBookingClass = null)
    {
        // validation for constraint: string
        if (!is_null($toBookingClass) && !is_string($toBookingClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toBookingClass)), __LINE__);
        }
        $this->toBookingClass = $toBookingClass;
        return $this;
    }
    /**
     * Get noOfSeats value
     * @return int|null
     */
    public function getNoOfSeats()
    {
        return $this->noOfSeats;
    }
    /**
     * Set noOfSeats value
     * @param int $noOfSeats
     * @return \StructType\AAInventorySeatMovementType
     */
    public function setNoOfSeats($noOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($noOfSeats) && !is_numeric($noOfSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfSeats)), __LINE__);
        }
        $this->noOfSeats = $noOfSeats;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\AAInventorySeatMovementType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAInventorySeatMovementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
