<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAIOBoundPaxCountInfoRS StructType
 * Meta informations extracted from the WSDL
 * - type: ns2:AAIOBoundPaxCountInfoRS
 * @subpackage Structs
 */
class AAIOBoundPaxCountInfoRS extends AbstractStructBase
{
    /**
     * The airportPaxTypeCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAAirportSummaryType[]
     */
    public $airportPaxTypeCounts;
    /**
     * The successOrError
     * @var \StructType\AAResultType
     */
    public $successOrError;
    /**
     * Constructor method for AAIOBoundPaxCountInfoRS
     * @uses AAIOBoundPaxCountInfoRS::setAirportPaxTypeCounts()
     * @uses AAIOBoundPaxCountInfoRS::setSuccessOrError()
     * @param \StructType\AAAirportSummaryType[] $airportPaxTypeCounts
     * @param \StructType\AAResultType $successOrError
     */
    public function __construct(array $airportPaxTypeCounts = array(), \StructType\AAResultType $successOrError = null)
    {
        $this
            ->setAirportPaxTypeCounts($airportPaxTypeCounts)
            ->setSuccessOrError($successOrError);
    }
    /**
     * Get airportPaxTypeCounts value
     * @return \StructType\AAAirportSummaryType[]|null
     */
    public function getAirportPaxTypeCounts()
    {
        return $this->airportPaxTypeCounts;
    }
    /**
     * Set airportPaxTypeCounts value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAirportSummaryType[] $airportPaxTypeCounts
     * @return \StructType\AAIOBoundPaxCountInfoRS
     */
    public function setAirportPaxTypeCounts(array $airportPaxTypeCounts = array())
    {
        foreach ($airportPaxTypeCounts as $aAIOBoundPaxCountInfoRSAirportPaxTypeCountsItem) {
            // validation for constraint: itemType
            if (!$aAIOBoundPaxCountInfoRSAirportPaxTypeCountsItem instanceof \StructType\AAAirportSummaryType) {
                throw new \InvalidArgumentException(sprintf('The airportPaxTypeCounts property can only contain items of \StructType\AAAirportSummaryType, "%s" given', is_object($aAIOBoundPaxCountInfoRSAirportPaxTypeCountsItem) ? get_class($aAIOBoundPaxCountInfoRSAirportPaxTypeCountsItem) : gettype($aAIOBoundPaxCountInfoRSAirportPaxTypeCountsItem)), __LINE__);
            }
        }
        $this->airportPaxTypeCounts = $airportPaxTypeCounts;
        return $this;
    }
    /**
     * Add item to airportPaxTypeCounts value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAirportSummaryType $item
     * @return \StructType\AAIOBoundPaxCountInfoRS
     */
    public function addToAirportPaxTypeCounts(\StructType\AAAirportSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAAirportSummaryType) {
            throw new \InvalidArgumentException(sprintf('The airportPaxTypeCounts property can only contain items of \StructType\AAAirportSummaryType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->airportPaxTypeCounts[] = $item;
        return $this;
    }
    /**
     * Get successOrError value
     * @return \StructType\AAResultType|null
     */
    public function getSuccessOrError()
    {
        return $this->successOrError;
    }
    /**
     * Set successOrError value
     * @param \StructType\AAResultType $successOrError
     * @return \StructType\AAIOBoundPaxCountInfoRS
     */
    public function setSuccessOrError(\StructType\AAResultType $successOrError = null)
    {
        $this->successOrError = $successOrError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAIOBoundPaxCountInfoRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
