<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFlightInvUpdateRQ StructType
 * @subpackage Structs
 */
class AAFlightInvUpdateRQ extends AbstractStructBase
{
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The depatureDate
     * @var string
     */
    public $depatureDate;
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * The cabinClass
     * @var string
     */
    public $cabinClass;
    /**
     * The operationType
     * @var string
     */
    public $operationType;
    /**
     * The oversellCount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $oversellCount;
    /**
     * The curtailCount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $curtailCount;
    /**
     * The fccSegBCInventoriesToAdd
     * @var \StructType\AAFCCSegBCInventoryAddType
     */
    public $fccSegBCInventoriesToAdd;
    /**
     * The fccSegBCInventoriesToUpdate
     * @var \StructType\AAFCCSegBCInventoryUpdateType
     */
    public $fccSegBCInventoriesToUpdate;
    /**
     * The fccSegBCInventoriesToDelete
     * @var \StructType\AAFCCSegBCInventoryDeleteType
     */
    public $fccSegBCInventoriesToDelete;
    /**
     * Constructor method for AAFlightInvUpdateRQ
     * @uses AAFlightInvUpdateRQ::setFlightNumber()
     * @uses AAFlightInvUpdateRQ::setDepatureDate()
     * @uses AAFlightInvUpdateRQ::setSegmentCode()
     * @uses AAFlightInvUpdateRQ::setCabinClass()
     * @uses AAFlightInvUpdateRQ::setOperationType()
     * @uses AAFlightInvUpdateRQ::setOversellCount()
     * @uses AAFlightInvUpdateRQ::setCurtailCount()
     * @uses AAFlightInvUpdateRQ::setFccSegBCInventoriesToAdd()
     * @uses AAFlightInvUpdateRQ::setFccSegBCInventoriesToUpdate()
     * @uses AAFlightInvUpdateRQ::setFccSegBCInventoriesToDelete()
     * @param string $flightNumber
     * @param string $depatureDate
     * @param string $segmentCode
     * @param string $cabinClass
     * @param string $operationType
     * @param int $oversellCount
     * @param int $curtailCount
     * @param \StructType\AAFCCSegBCInventoryAddType $fccSegBCInventoriesToAdd
     * @param \StructType\AAFCCSegBCInventoryUpdateType $fccSegBCInventoriesToUpdate
     * @param \StructType\AAFCCSegBCInventoryDeleteType $fccSegBCInventoriesToDelete
     */
    public function __construct($flightNumber = null, $depatureDate = null, $segmentCode = null, $cabinClass = null, $operationType = null, $oversellCount = null, $curtailCount = null, \StructType\AAFCCSegBCInventoryAddType $fccSegBCInventoriesToAdd = null, \StructType\AAFCCSegBCInventoryUpdateType $fccSegBCInventoriesToUpdate = null, \StructType\AAFCCSegBCInventoryDeleteType $fccSegBCInventoriesToDelete = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setDepatureDate($depatureDate)
            ->setSegmentCode($segmentCode)
            ->setCabinClass($cabinClass)
            ->setOperationType($operationType)
            ->setOversellCount($oversellCount)
            ->setCurtailCount($curtailCount)
            ->setFccSegBCInventoriesToAdd($fccSegBCInventoriesToAdd)
            ->setFccSegBCInventoriesToUpdate($fccSegBCInventoriesToUpdate)
            ->setFccSegBCInventoriesToDelete($fccSegBCInventoriesToDelete);
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get depatureDate value
     * @return string|null
     */
    public function getDepatureDate()
    {
        return $this->depatureDate;
    }
    /**
     * Set depatureDate value
     * @param string $depatureDate
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setDepatureDate($depatureDate = null)
    {
        // validation for constraint: string
        if (!is_null($depatureDate) && !is_string($depatureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depatureDate)), __LINE__);
        }
        $this->depatureDate = $depatureDate;
        return $this;
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get cabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->cabinClass;
    }
    /**
     * Set cabinClass value
     * @param string $cabinClass
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinClass)), __LINE__);
        }
        $this->cabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get operationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @param string $operationType
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationType)), __LINE__);
        }
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get oversellCount value
     * @return int|null
     */
    public function getOversellCount()
    {
        return $this->oversellCount;
    }
    /**
     * Set oversellCount value
     * @param int $oversellCount
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setOversellCount($oversellCount = null)
    {
        // validation for constraint: int
        if (!is_null($oversellCount) && !is_numeric($oversellCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oversellCount)), __LINE__);
        }
        $this->oversellCount = $oversellCount;
        return $this;
    }
    /**
     * Get curtailCount value
     * @return int|null
     */
    public function getCurtailCount()
    {
        return $this->curtailCount;
    }
    /**
     * Set curtailCount value
     * @param int $curtailCount
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setCurtailCount($curtailCount = null)
    {
        // validation for constraint: int
        if (!is_null($curtailCount) && !is_numeric($curtailCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($curtailCount)), __LINE__);
        }
        $this->curtailCount = $curtailCount;
        return $this;
    }
    /**
     * Get fccSegBCInventoriesToAdd value
     * @return \StructType\AAFCCSegBCInventoryAddType|null
     */
    public function getFccSegBCInventoriesToAdd()
    {
        return $this->fccSegBCInventoriesToAdd;
    }
    /**
     * Set fccSegBCInventoriesToAdd value
     * @param \StructType\AAFCCSegBCInventoryAddType $fccSegBCInventoriesToAdd
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setFccSegBCInventoriesToAdd(\StructType\AAFCCSegBCInventoryAddType $fccSegBCInventoriesToAdd = null)
    {
        $this->fccSegBCInventoriesToAdd = $fccSegBCInventoriesToAdd;
        return $this;
    }
    /**
     * Get fccSegBCInventoriesToUpdate value
     * @return \StructType\AAFCCSegBCInventoryUpdateType|null
     */
    public function getFccSegBCInventoriesToUpdate()
    {
        return $this->fccSegBCInventoriesToUpdate;
    }
    /**
     * Set fccSegBCInventoriesToUpdate value
     * @param \StructType\AAFCCSegBCInventoryUpdateType $fccSegBCInventoriesToUpdate
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setFccSegBCInventoriesToUpdate(\StructType\AAFCCSegBCInventoryUpdateType $fccSegBCInventoriesToUpdate = null)
    {
        $this->fccSegBCInventoriesToUpdate = $fccSegBCInventoriesToUpdate;
        return $this;
    }
    /**
     * Get fccSegBCInventoriesToDelete value
     * @return \StructType\AAFCCSegBCInventoryDeleteType|null
     */
    public function getFccSegBCInventoriesToDelete()
    {
        return $this->fccSegBCInventoriesToDelete;
    }
    /**
     * Set fccSegBCInventoriesToDelete value
     * @param \StructType\AAFCCSegBCInventoryDeleteType $fccSegBCInventoriesToDelete
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public function setFccSegBCInventoriesToDelete(\StructType\AAFCCSegBCInventoryDeleteType $fccSegBCInventoriesToDelete = null)
    {
        $this->fccSegBCInventoriesToDelete = $fccSegBCInventoriesToDelete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFlightInvUpdateRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
