<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAExternalPayTxType StructType
 * Meta informations extracted from the WSDL
 * - documentation: External payment trasaction information
 * @subpackage Structs
 */
class AAExternalPayTxType extends AbstractStructBase
{
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AAPropertiesType
     */
    public $Properties;
    /**
     * The BookingReferenceID
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The BalanceQueryRPH
     * @var string
     */
    public $BalanceQueryRPH;
    /**
     * The AATxStatus
     * @var string
     */
    public $AATxStatus;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The BankChannelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BankChannelCode;
    /**
     * The ExternalSystemTxRPH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExternalSystemTxRPH;
    /**
     * The ExternalTxStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExternalTxStatus;
    /**
     * The AATxStartTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $AATxStartTimestamp;
    /**
     * The AATxEndTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $AATxEndTimestamp;
    /**
     * The ExternalTxTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $ExternalTxTimestamp;
    /**
     * The PaxCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaxCount;
    /**
     * Constructor method for AAExternalPayTxType
     * @uses AAExternalPayTxType::setProperties()
     * @uses AAExternalPayTxType::setBookingReferenceID()
     * @uses AAExternalPayTxType::setBalanceQueryRPH()
     * @uses AAExternalPayTxType::setAATxStatus()
     * @uses AAExternalPayTxType::setAmount()
     * @uses AAExternalPayTxType::setBankChannelCode()
     * @uses AAExternalPayTxType::setExternalSystemTxRPH()
     * @uses AAExternalPayTxType::setExternalTxStatus()
     * @uses AAExternalPayTxType::setAATxStartTimestamp()
     * @uses AAExternalPayTxType::setAATxEndTimestamp()
     * @uses AAExternalPayTxType::setExternalTxTimestamp()
     * @uses AAExternalPayTxType::setPaxCount()
     * @param \StructType\AAPropertiesType $properties
     * @param string $bookingReferenceID
     * @param string $balanceQueryRPH
     * @param string $aATxStatus
     * @param float $amount
     * @param string $bankChannelCode
     * @param string $externalSystemTxRPH
     * @param string $externalTxStatus
     * @param string $aATxStartTimestamp
     * @param string $aATxEndTimestamp
     * @param string $externalTxTimestamp
     * @param string $paxCount
     */
    public function __construct(\StructType\AAPropertiesType $properties = null, $bookingReferenceID = null, $balanceQueryRPH = null, $aATxStatus = null, $amount = null, $bankChannelCode = null, $externalSystemTxRPH = null, $externalTxStatus = null, $aATxStartTimestamp = null, $aATxEndTimestamp = null, $externalTxTimestamp = null, $paxCount = null)
    {
        $this
            ->setProperties($properties)
            ->setBookingReferenceID($bookingReferenceID)
            ->setBalanceQueryRPH($balanceQueryRPH)
            ->setAATxStatus($aATxStatus)
            ->setAmount($amount)
            ->setBankChannelCode($bankChannelCode)
            ->setExternalSystemTxRPH($externalSystemTxRPH)
            ->setExternalTxStatus($externalTxStatus)
            ->setAATxStartTimestamp($aATxStartTimestamp)
            ->setAATxEndTimestamp($aATxEndTimestamp)
            ->setExternalTxTimestamp($externalTxTimestamp)
            ->setPaxCount($paxCount);
    }
    /**
     * Get Properties value
     * @return \StructType\AAPropertiesType|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \StructType\AAPropertiesType $properties
     * @return \StructType\AAExternalPayTxType
     */
    public function setProperties(\StructType\AAPropertiesType $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AAExternalPayTxType
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get BalanceQueryRPH value
     * @return string|null
     */
    public function getBalanceQueryRPH()
    {
        return $this->BalanceQueryRPH;
    }
    /**
     * Set BalanceQueryRPH value
     * @param string $balanceQueryRPH
     * @return \StructType\AAExternalPayTxType
     */
    public function setBalanceQueryRPH($balanceQueryRPH = null)
    {
        // validation for constraint: string
        if (!is_null($balanceQueryRPH) && !is_string($balanceQueryRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceQueryRPH)), __LINE__);
        }
        $this->BalanceQueryRPH = $balanceQueryRPH;
        return $this;
    }
    /**
     * Get AATxStatus value
     * @return string|null
     */
    public function getAATxStatus()
    {
        return $this->AATxStatus;
    }
    /**
     * Set AATxStatus value
     * @param string $aATxStatus
     * @return \StructType\AAExternalPayTxType
     */
    public function setAATxStatus($aATxStatus = null)
    {
        // validation for constraint: string
        if (!is_null($aATxStatus) && !is_string($aATxStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aATxStatus)), __LINE__);
        }
        $this->AATxStatus = $aATxStatus;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AAExternalPayTxType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BankChannelCode value
     * @return string|null
     */
    public function getBankChannelCode()
    {
        return $this->BankChannelCode;
    }
    /**
     * Set BankChannelCode value
     * @param string $bankChannelCode
     * @return \StructType\AAExternalPayTxType
     */
    public function setBankChannelCode($bankChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankChannelCode) && !is_string($bankChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankChannelCode)), __LINE__);
        }
        $this->BankChannelCode = $bankChannelCode;
        return $this;
    }
    /**
     * Get ExternalSystemTxRPH value
     * @return string|null
     */
    public function getExternalSystemTxRPH()
    {
        return $this->ExternalSystemTxRPH;
    }
    /**
     * Set ExternalSystemTxRPH value
     * @param string $externalSystemTxRPH
     * @return \StructType\AAExternalPayTxType
     */
    public function setExternalSystemTxRPH($externalSystemTxRPH = null)
    {
        // validation for constraint: string
        if (!is_null($externalSystemTxRPH) && !is_string($externalSystemTxRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalSystemTxRPH)), __LINE__);
        }
        $this->ExternalSystemTxRPH = $externalSystemTxRPH;
        return $this;
    }
    /**
     * Get ExternalTxStatus value
     * @return string|null
     */
    public function getExternalTxStatus()
    {
        return $this->ExternalTxStatus;
    }
    /**
     * Set ExternalTxStatus value
     * @param string $externalTxStatus
     * @return \StructType\AAExternalPayTxType
     */
    public function setExternalTxStatus($externalTxStatus = null)
    {
        // validation for constraint: string
        if (!is_null($externalTxStatus) && !is_string($externalTxStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalTxStatus)), __LINE__);
        }
        $this->ExternalTxStatus = $externalTxStatus;
        return $this;
    }
    /**
     * Get AATxStartTimestamp value
     * @return string|null
     */
    public function getAATxStartTimestamp()
    {
        return $this->AATxStartTimestamp;
    }
    /**
     * Set AATxStartTimestamp value
     * @param string $aATxStartTimestamp
     * @return \StructType\AAExternalPayTxType
     */
    public function setAATxStartTimestamp($aATxStartTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($aATxStartTimestamp) && !is_string($aATxStartTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aATxStartTimestamp)), __LINE__);
        }
        $this->AATxStartTimestamp = $aATxStartTimestamp;
        return $this;
    }
    /**
     * Get AATxEndTimestamp value
     * @return string|null
     */
    public function getAATxEndTimestamp()
    {
        return $this->AATxEndTimestamp;
    }
    /**
     * Set AATxEndTimestamp value
     * @param string $aATxEndTimestamp
     * @return \StructType\AAExternalPayTxType
     */
    public function setAATxEndTimestamp($aATxEndTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($aATxEndTimestamp) && !is_string($aATxEndTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aATxEndTimestamp)), __LINE__);
        }
        $this->AATxEndTimestamp = $aATxEndTimestamp;
        return $this;
    }
    /**
     * Get ExternalTxTimestamp value
     * @return string|null
     */
    public function getExternalTxTimestamp()
    {
        return $this->ExternalTxTimestamp;
    }
    /**
     * Set ExternalTxTimestamp value
     * @param string $externalTxTimestamp
     * @return \StructType\AAExternalPayTxType
     */
    public function setExternalTxTimestamp($externalTxTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($externalTxTimestamp) && !is_string($externalTxTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalTxTimestamp)), __LINE__);
        }
        $this->ExternalTxTimestamp = $externalTxTimestamp;
        return $this;
    }
    /**
     * Get PaxCount value
     * @return string|null
     */
    public function getPaxCount()
    {
        return $this->PaxCount;
    }
    /**
     * Set PaxCount value
     * @param string $paxCount
     * @return \StructType\AAExternalPayTxType
     */
    public function setPaxCount($paxCount = null)
    {
        // validation for constraint: string
        if (!is_null($paxCount) && !is_string($paxCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paxCount)), __LINE__);
        }
        $this->PaxCount = $paxCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAExternalPayTxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
