<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAEmergencyContactType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Caputures Emergency Contact information
 * @subpackage Structs
 */
class AAEmergencyContactType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AAPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AATelephoneType
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for AAEmergencyContactType
     * @uses AAEmergencyContactType::setPersonName()
     * @uses AAEmergencyContactType::setTelephone()
     * @uses AAEmergencyContactType::setEmail()
     * @param \StructType\AAPersonNameType $personName
     * @param \StructType\AATelephoneType $telephone
     * @param string $email
     */
    public function __construct(\StructType\AAPersonNameType $personName = null, \StructType\AATelephoneType $telephone = null, $email = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email);
    }
    /**
     * Get PersonName value
     * @return \StructType\AAPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\AAPersonNameType $personName
     * @return \StructType\AAEmergencyContactType
     */
    public function setPersonName(\StructType\AAPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\AATelephoneType|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\AATelephoneType $telephone
     * @return \StructType\AAEmergencyContactType
     */
    public function setTelephone(\StructType\AATelephoneType $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AAEmergencyContactType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAEmergencyContactType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
