<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAContactInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reservation contact information.
 * @subpackage Structs
 */
class AAContactInfoType extends AbstractStructBase
{
    /**
     * The ProfileRef
     * Meta informations extracted from the WSDL
     * - documentation: An identifier used to uniquely reference a customer profile.
     * - minOccurs: 0
     * @var string
     */
    public $ProfileRef;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - documentation: Person Name information of the contact person.
     * @var \StructType\AAPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - documentation: Mobile number for the contact person.
     * - minOccurs: 0
     * @var \StructType\AATelephoneType
     */
    public $Telephone;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - documentation: Mobile number for the contact person.
     * - minOccurs: 0
     * @var \StructType\AATelephoneType
     */
    public $Mobile;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - documentation: Fax number for the contact person.
     * - minOccurs: 0
     * @var \StructType\AATelephoneType
     */
    public $Fax;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Email address of the contact person.
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Address information of the contact person.
     * - minOccurs: 0
     * @var \StructType\AAAddressType
     */
    public $Address;
    /**
     * The PreferredLanguage
     * Meta informations extracted from the WSDL
     * - documentation: Preferred language of the contact person
     * - minOccurs: 0
     * @var string
     */
    public $PreferredLanguage;
    /**
     * The EmergencyContact
     * Meta informations extracted from the WSDL
     * - documentation: Emergency Contact Information
     * - minOccurs: 0
     * @var \StructType\AAEmergencyContactType
     */
    public $EmergencyContact;
    /**
     * Constructor method for AAContactInfoType
     * @uses AAContactInfoType::setProfileRef()
     * @uses AAContactInfoType::setPersonName()
     * @uses AAContactInfoType::setTelephone()
     * @uses AAContactInfoType::setMobile()
     * @uses AAContactInfoType::setFax()
     * @uses AAContactInfoType::setEmail()
     * @uses AAContactInfoType::setAddress()
     * @uses AAContactInfoType::setPreferredLanguage()
     * @uses AAContactInfoType::setEmergencyContact()
     * @param string $profileRef
     * @param \StructType\AAPersonNameType $personName
     * @param \StructType\AATelephoneType $telephone
     * @param \StructType\AATelephoneType $mobile
     * @param \StructType\AATelephoneType $fax
     * @param string $email
     * @param \StructType\AAAddressType $address
     * @param string $preferredLanguage
     * @param \StructType\AAEmergencyContactType $emergencyContact
     */
    public function __construct($profileRef = null, \StructType\AAPersonNameType $personName = null, \StructType\AATelephoneType $telephone = null, \StructType\AATelephoneType $mobile = null, \StructType\AATelephoneType $fax = null, $email = null, \StructType\AAAddressType $address = null, $preferredLanguage = null, \StructType\AAEmergencyContactType $emergencyContact = null)
    {
        $this
            ->setProfileRef($profileRef)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setAddress($address)
            ->setPreferredLanguage($preferredLanguage)
            ->setEmergencyContact($emergencyContact);
    }
    /**
     * Get ProfileRef value
     * @return string|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param string $profileRef
     * @return \StructType\AAContactInfoType
     */
    public function setProfileRef($profileRef = null)
    {
        // validation for constraint: string
        if (!is_null($profileRef) && !is_string($profileRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileRef)), __LINE__);
        }
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\AAPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\AAPersonNameType $personName
     * @return \StructType\AAContactInfoType
     */
    public function setPersonName(\StructType\AAPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\AATelephoneType|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\AATelephoneType $telephone
     * @return \StructType\AAContactInfoType
     */
    public function setTelephone(\StructType\AATelephoneType $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return \StructType\AATelephoneType|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param \StructType\AATelephoneType $mobile
     * @return \StructType\AAContactInfoType
     */
    public function setMobile(\StructType\AATelephoneType $mobile = null)
    {
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return \StructType\AATelephoneType|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \StructType\AATelephoneType $fax
     * @return \StructType\AAContactInfoType
     */
    public function setFax(\StructType\AATelephoneType $fax = null)
    {
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AAContactInfoType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AAAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AAAddressType $address
     * @return \StructType\AAContactInfoType
     */
    public function setAddress(\StructType\AAAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get PreferredLanguage value
     * @return string|null
     */
    public function getPreferredLanguage()
    {
        return $this->PreferredLanguage;
    }
    /**
     * Set PreferredLanguage value
     * @param string $preferredLanguage
     * @return \StructType\AAContactInfoType
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLanguage)), __LINE__);
        }
        $this->PreferredLanguage = $preferredLanguage;
        return $this;
    }
    /**
     * Get EmergencyContact value
     * @return \StructType\AAEmergencyContactType|null
     */
    public function getEmergencyContact()
    {
        return $this->EmergencyContact;
    }
    /**
     * Set EmergencyContact value
     * @param \StructType\AAEmergencyContactType $emergencyContact
     * @return \StructType\AAContactInfoType
     */
    public function setEmergencyContact(\StructType\AAEmergencyContactType $emergencyContact = null)
    {
        $this->EmergencyContact = $emergencyContact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAContactInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
