<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAlterationBalancesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Balance amounts when performing reservation modifications. Used in cancel segment, cancel reservation, add segment, modify segment, add infant and remove pax processes to show balance amounts. New balances (except OND balances) are
 * formed with respect to the overall reservation.
 * @subpackage Structs
 */
class AAAlterationBalancesType extends AbstractStructBase
{
    /**
     * The AAModONDBalances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AAModONDBalances
     */
    public $AAModONDBalances;
    /**
     * The AACnxONDBalances
     * Meta informations extracted from the WSDL
     * - documentation: Balances for OND being cancelled.
     * - minOccurs: 0
     * @var \StructType\AACnxModAddONDBalancesType
     */
    public $AACnxONDBalances;
    /**
     * The AAAddONDBalances
     * Meta informations extracted from the WSDL
     * - documentation: Balances for OND being added.
     * - minOccurs: 0
     * @var \StructType\AACnxModAddONDBalancesType
     */
    public $AAAddONDBalances;
    /**
     * The TravelersCnxModAddResBalances
     * Meta informations extracted from the WSDL
     * - documentation: Traveler balances with respect to the resevation, after modificatin/cancelation.
     * - minOccurs: 0
     * @var \StructType\AATravelersCnxModAddResBalancesType
     */
    public $TravelersCnxModAddResBalances;
    /**
     * The TotalModChargeForCurrentOperation
     * Meta informations extracted from the WSDL
     * - documentation: Per traveler per OND modification charge
     * - minOccurs: 0
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalModChargeForCurrentOperation;
    /**
     * The TotalCnxChargeForCurrentOperation
     * Meta informations extracted from the WSDL
     * - documentation: Per traveler per OND cancellation charge
     * - minOccurs: 0
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalCnxChargeForCurrentOperation;
    /**
     * The TotalCreditAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total credit amount for the reservation after modification/cancellation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalCreditAmount;
    /**
     * The TotalAmountDue
     * Meta informations extracted from the WSDL
     * - documentation: Total amount due for the resevation after modificaiton/cancellation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalAmountDue;
    /**
     * The TotalAmountDueCC
     * Meta informations extracted from the WSDL
     * - documentation: Total amount due for the resevation after modificaiton/cancellation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalAmountDueCC;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - documentation: Total amount due for the resevation after modificaiton/cancellation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPrice;
    /**
     * The TotalPriceCC
     * Meta informations extracted from the WSDL
     * - documentation: Total amount due for the resevation after modificaiton/cancellation.
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPriceCC;
    /**
     * Constructor method for AAAlterationBalancesType
     * @uses AAAlterationBalancesType::setAAModONDBalances()
     * @uses AAAlterationBalancesType::setAACnxONDBalances()
     * @uses AAAlterationBalancesType::setAAAddONDBalances()
     * @uses AAAlterationBalancesType::setTravelersCnxModAddResBalances()
     * @uses AAAlterationBalancesType::setTotalModChargeForCurrentOperation()
     * @uses AAAlterationBalancesType::setTotalCnxChargeForCurrentOperation()
     * @uses AAAlterationBalancesType::setTotalCreditAmount()
     * @uses AAAlterationBalancesType::setTotalAmountDue()
     * @uses AAAlterationBalancesType::setTotalAmountDueCC()
     * @uses AAAlterationBalancesType::setTotalPrice()
     * @uses AAAlterationBalancesType::setTotalPriceCC()
     * @param \StructType\AAModONDBalances $aAModONDBalances
     * @param \StructType\AACnxModAddONDBalancesType $aACnxONDBalances
     * @param \StructType\AACnxModAddONDBalancesType $aAAddONDBalances
     * @param \StructType\AATravelersCnxModAddResBalancesType $travelersCnxModAddResBalances
     * @param \StructType\AACurrencyAmountType $totalModChargeForCurrentOperation
     * @param \StructType\AACurrencyAmountType $totalCnxChargeForCurrentOperation
     * @param \StructType\AACurrencyAmountType $totalCreditAmount
     * @param \StructType\AACurrencyAmountType $totalAmountDue
     * @param \StructType\AACurrencyAmountType $totalAmountDueCC
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @param \StructType\AACurrencyAmountType $totalPriceCC
     */
    public function __construct(\StructType\AAModONDBalances $aAModONDBalances = null, \StructType\AACnxModAddONDBalancesType $aACnxONDBalances = null, \StructType\AACnxModAddONDBalancesType $aAAddONDBalances = null, \StructType\AATravelersCnxModAddResBalancesType $travelersCnxModAddResBalances = null, \StructType\AACurrencyAmountType $totalModChargeForCurrentOperation = null, \StructType\AACurrencyAmountType $totalCnxChargeForCurrentOperation = null, \StructType\AACurrencyAmountType $totalCreditAmount = null, \StructType\AACurrencyAmountType $totalAmountDue = null, \StructType\AACurrencyAmountType $totalAmountDueCC = null, \StructType\AACurrencyAmountType $totalPrice = null, \StructType\AACurrencyAmountType $totalPriceCC = null)
    {
        $this
            ->setAAModONDBalances($aAModONDBalances)
            ->setAACnxONDBalances($aACnxONDBalances)
            ->setAAAddONDBalances($aAAddONDBalances)
            ->setTravelersCnxModAddResBalances($travelersCnxModAddResBalances)
            ->setTotalModChargeForCurrentOperation($totalModChargeForCurrentOperation)
            ->setTotalCnxChargeForCurrentOperation($totalCnxChargeForCurrentOperation)
            ->setTotalCreditAmount($totalCreditAmount)
            ->setTotalAmountDue($totalAmountDue)
            ->setTotalAmountDueCC($totalAmountDueCC)
            ->setTotalPrice($totalPrice)
            ->setTotalPriceCC($totalPriceCC);
    }
    /**
     * Get AAModONDBalances value
     * @return \StructType\AAModONDBalances|null
     */
    public function getAAModONDBalances()
    {
        return $this->AAModONDBalances;
    }
    /**
     * Set AAModONDBalances value
     * @param \StructType\AAModONDBalances $aAModONDBalances
     * @return \StructType\AAAlterationBalancesType
     */
    public function setAAModONDBalances(\StructType\AAModONDBalances $aAModONDBalances = null)
    {
        $this->AAModONDBalances = $aAModONDBalances;
        return $this;
    }
    /**
     * Get AACnxONDBalances value
     * @return \StructType\AACnxModAddONDBalancesType|null
     */
    public function getAACnxONDBalances()
    {
        return $this->AACnxONDBalances;
    }
    /**
     * Set AACnxONDBalances value
     * @param \StructType\AACnxModAddONDBalancesType $aACnxONDBalances
     * @return \StructType\AAAlterationBalancesType
     */
    public function setAACnxONDBalances(\StructType\AACnxModAddONDBalancesType $aACnxONDBalances = null)
    {
        $this->AACnxONDBalances = $aACnxONDBalances;
        return $this;
    }
    /**
     * Get AAAddONDBalances value
     * @return \StructType\AACnxModAddONDBalancesType|null
     */
    public function getAAAddONDBalances()
    {
        return $this->AAAddONDBalances;
    }
    /**
     * Set AAAddONDBalances value
     * @param \StructType\AACnxModAddONDBalancesType $aAAddONDBalances
     * @return \StructType\AAAlterationBalancesType
     */
    public function setAAAddONDBalances(\StructType\AACnxModAddONDBalancesType $aAAddONDBalances = null)
    {
        $this->AAAddONDBalances = $aAAddONDBalances;
        return $this;
    }
    /**
     * Get TravelersCnxModAddResBalances value
     * @return \StructType\AATravelersCnxModAddResBalancesType|null
     */
    public function getTravelersCnxModAddResBalances()
    {
        return $this->TravelersCnxModAddResBalances;
    }
    /**
     * Set TravelersCnxModAddResBalances value
     * @param \StructType\AATravelersCnxModAddResBalancesType $travelersCnxModAddResBalances
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTravelersCnxModAddResBalances(\StructType\AATravelersCnxModAddResBalancesType $travelersCnxModAddResBalances = null)
    {
        $this->TravelersCnxModAddResBalances = $travelersCnxModAddResBalances;
        return $this;
    }
    /**
     * Get TotalModChargeForCurrentOperation value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalModChargeForCurrentOperation()
    {
        return $this->TotalModChargeForCurrentOperation;
    }
    /**
     * Set TotalModChargeForCurrentOperation value
     * @param \StructType\AACurrencyAmountType $totalModChargeForCurrentOperation
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalModChargeForCurrentOperation(\StructType\AACurrencyAmountType $totalModChargeForCurrentOperation = null)
    {
        $this->TotalModChargeForCurrentOperation = $totalModChargeForCurrentOperation;
        return $this;
    }
    /**
     * Get TotalCnxChargeForCurrentOperation value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalCnxChargeForCurrentOperation()
    {
        return $this->TotalCnxChargeForCurrentOperation;
    }
    /**
     * Set TotalCnxChargeForCurrentOperation value
     * @param \StructType\AACurrencyAmountType $totalCnxChargeForCurrentOperation
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalCnxChargeForCurrentOperation(\StructType\AACurrencyAmountType $totalCnxChargeForCurrentOperation = null)
    {
        $this->TotalCnxChargeForCurrentOperation = $totalCnxChargeForCurrentOperation;
        return $this;
    }
    /**
     * Get TotalCreditAmount value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalCreditAmount()
    {
        return $this->TotalCreditAmount;
    }
    /**
     * Set TotalCreditAmount value
     * @param \StructType\AACurrencyAmountType $totalCreditAmount
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalCreditAmount(\StructType\AACurrencyAmountType $totalCreditAmount = null)
    {
        $this->TotalCreditAmount = $totalCreditAmount;
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalAmountDue()
    {
        return $this->TotalAmountDue;
    }
    /**
     * Set TotalAmountDue value
     * @param \StructType\AACurrencyAmountType $totalAmountDue
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalAmountDue(\StructType\AACurrencyAmountType $totalAmountDue = null)
    {
        $this->TotalAmountDue = $totalAmountDue;
        return $this;
    }
    /**
     * Get TotalAmountDueCC value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalAmountDueCC()
    {
        return $this->TotalAmountDueCC;
    }
    /**
     * Set TotalAmountDueCC value
     * @param \StructType\AACurrencyAmountType $totalAmountDueCC
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalAmountDueCC(\StructType\AACurrencyAmountType $totalAmountDueCC = null)
    {
        $this->TotalAmountDueCC = $totalAmountDueCC;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalPrice(\StructType\AACurrencyAmountType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalPriceCC value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPriceCC()
    {
        return $this->TotalPriceCC;
    }
    /**
     * Set TotalPriceCC value
     * @param \StructType\AACurrencyAmountType $totalPriceCC
     * @return \StructType\AAAlterationBalancesType
     */
    public function setTotalPriceCC(\StructType\AACurrencyAmountType $totalPriceCC = null)
    {
        $this->TotalPriceCC = $totalPriceCC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAlterationBalancesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
