<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAirportSummaryType StructType
 * @subpackage Structs
 */
class AAAirportSummaryType extends AbstractStructBase
{
    /**
     * The airportCode
     * @var string
     */
    public $airportCode;
    /**
     * The journeyType
     * @var string
     */
    public $journeyType;
    /**
     * The paxCount
     * @var int
     */
    public $paxCount;
    /**
     * Constructor method for AAAirportSummaryType
     * @uses AAAirportSummaryType::setAirportCode()
     * @uses AAAirportSummaryType::setJourneyType()
     * @uses AAAirportSummaryType::setPaxCount()
     * @param string $airportCode
     * @param string $journeyType
     * @param int $paxCount
     */
    public function __construct($airportCode = null, $journeyType = null, $paxCount = null)
    {
        $this
            ->setAirportCode($airportCode)
            ->setJourneyType($journeyType)
            ->setPaxCount($paxCount);
    }
    /**
     * Get airportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->airportCode;
    }
    /**
     * Set airportCode value
     * @param string $airportCode
     * @return \StructType\AAAirportSummaryType
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airportCode)), __LINE__);
        }
        $this->airportCode = $airportCode;
        return $this;
    }
    /**
     * Get journeyType value
     * @return string|null
     */
    public function getJourneyType()
    {
        return $this->journeyType;
    }
    /**
     * Set journeyType value
     * @param string $journeyType
     * @return \StructType\AAAirportSummaryType
     */
    public function setJourneyType($journeyType = null)
    {
        // validation for constraint: string
        if (!is_null($journeyType) && !is_string($journeyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($journeyType)), __LINE__);
        }
        $this->journeyType = $journeyType;
        return $this;
    }
    /**
     * Get paxCount value
     * @return int|null
     */
    public function getPaxCount()
    {
        return $this->paxCount;
    }
    /**
     * Set paxCount value
     * @param int $paxCount
     * @return \StructType\AAAirportSummaryType
     */
    public function setPaxCount($paxCount = null)
    {
        // validation for constraint: int
        if (!is_null($paxCount) && !is_numeric($paxCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paxCount)), __LINE__);
        }
        $this->paxCount = $paxCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAirportSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
