<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAirTravelerType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Traveler (PAX) additional details.
 * @subpackage Structs
 */
class AAAirTravelerType extends AbstractStructBase
{
    /**
     * The TravelerRefNumberRPH
     * @var string
     */
    public $TravelerRefNumberRPH;
    /**
     * The FOIDNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FOIDNumber;
    /**
     * The NationalIDNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NationalIDNo;
    /**
     * The PaxCategoryFOIDId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaxCategoryFOIDId;
    /**
     * Constructor method for AAAirTravelerType
     * @uses AAAirTravelerType::setTravelerRefNumberRPH()
     * @uses AAAirTravelerType::setFOIDNumber()
     * @uses AAAirTravelerType::setNationalIDNo()
     * @uses AAAirTravelerType::setPaxCategoryFOIDId()
     * @param string $travelerRefNumberRPH
     * @param string $fOIDNumber
     * @param string $nationalIDNo
     * @param string $paxCategoryFOIDId
     */
    public function __construct($travelerRefNumberRPH = null, $fOIDNumber = null, $nationalIDNo = null, $paxCategoryFOIDId = null)
    {
        $this
            ->setTravelerRefNumberRPH($travelerRefNumberRPH)
            ->setFOIDNumber($fOIDNumber)
            ->setNationalIDNo($nationalIDNo)
            ->setPaxCategoryFOIDId($paxCategoryFOIDId);
    }
    /**
     * Get TravelerRefNumberRPH value
     * @return string|null
     */
    public function getTravelerRefNumberRPH()
    {
        return $this->TravelerRefNumberRPH;
    }
    /**
     * Set TravelerRefNumberRPH value
     * @param string $travelerRefNumberRPH
     * @return \StructType\AAAirTravelerType
     */
    public function setTravelerRefNumberRPH($travelerRefNumberRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumberRPH) && !is_string($travelerRefNumberRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumberRPH)), __LINE__);
        }
        $this->TravelerRefNumberRPH = $travelerRefNumberRPH;
        return $this;
    }
    /**
     * Get FOIDNumber value
     * @return string|null
     */
    public function getFOIDNumber()
    {
        return $this->FOIDNumber;
    }
    /**
     * Set FOIDNumber value
     * @param string $fOIDNumber
     * @return \StructType\AAAirTravelerType
     */
    public function setFOIDNumber($fOIDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fOIDNumber) && !is_string($fOIDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fOIDNumber)), __LINE__);
        }
        $this->FOIDNumber = $fOIDNumber;
        return $this;
    }
    /**
     * Get NationalIDNo value
     * @return string|null
     */
    public function getNationalIDNo()
    {
        return $this->NationalIDNo;
    }
    /**
     * Set NationalIDNo value
     * @param string $nationalIDNo
     * @return \StructType\AAAirTravelerType
     */
    public function setNationalIDNo($nationalIDNo = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIDNo) && !is_string($nationalIDNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalIDNo)), __LINE__);
        }
        $this->NationalIDNo = $nationalIDNo;
        return $this;
    }
    /**
     * Get PaxCategoryFOIDId value
     * @return string|null
     */
    public function getPaxCategoryFOIDId()
    {
        return $this->PaxCategoryFOIDId;
    }
    /**
     * Set PaxCategoryFOIDId value
     * @param string $paxCategoryFOIDId
     * @return \StructType\AAAirTravelerType
     */
    public function setPaxCategoryFOIDId($paxCategoryFOIDId = null)
    {
        // validation for constraint: string
        if (!is_null($paxCategoryFOIDId) && !is_string($paxCategoryFOIDId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paxCategoryFOIDId)), __LINE__);
        }
        $this->PaxCategoryFOIDId = $paxCategoryFOIDId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAirTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
