<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAirBookRQExt StructType
 * Meta informations extracted from the WSDL
 * - documentation: AccelAero Extensions for OTA AirBookRQ, which is included as TPA_Extension
 * @subpackage Structs
 */
class AAAirBookRQExt extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - documentation: Reservation contact information
     * - minOccurs: 0
     * @var \StructType\AAContactInfoType
     */
    public $ContactInfo;
    /**
     * The UserNotes
     * Meta informations extracted from the WSDL
     * - documentation: Free Text Notes
     * - minOccurs: 0
     * @var \StructType\AAUserNotesType
     */
    public $UserNotes;
    /**
     * The AALoadDataOptions
     * Meta informations extracted from the WSDL
     * - documentation: Items to load in the response.
     * - minOccurs: 0
     * @var \StructType\AALoadDataOptionsType
     */
    public $AALoadDataOptions;
    /**
     * The TravelerAdditionalInfo
     * Meta informations extracted from the WSDL
     * - documentation: Travellers Additional Information
     * - minOccurs: 0
     * @var \StructType\AATravelerInfoType
     */
    public $TravelerAdditionalInfo;
    /**
     * The BookingCategoryType
     * Meta informations extracted from the WSDL
     * - documentation: Category of the booking
     * - minOccurs: 0
     * @var \StructType\AABookingCategoryType
     */
    public $BookingCategoryType;
    /**
     * Constructor method for AAAirBookRQExt
     * @uses AAAirBookRQExt::setContactInfo()
     * @uses AAAirBookRQExt::setUserNotes()
     * @uses AAAirBookRQExt::setAALoadDataOptions()
     * @uses AAAirBookRQExt::setTravelerAdditionalInfo()
     * @uses AAAirBookRQExt::setBookingCategoryType()
     * @param \StructType\AAContactInfoType $contactInfo
     * @param \StructType\AAUserNotesType $userNotes
     * @param \StructType\AALoadDataOptionsType $aALoadDataOptions
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     * @param \StructType\AABookingCategoryType $bookingCategoryType
     */
    public function __construct(\StructType\AAContactInfoType $contactInfo = null, \StructType\AAUserNotesType $userNotes = null, \StructType\AALoadDataOptionsType $aALoadDataOptions = null, \StructType\AATravelerInfoType $travelerAdditionalInfo = null, \StructType\AABookingCategoryType $bookingCategoryType = null)
    {
        $this
            ->setContactInfo($contactInfo)
            ->setUserNotes($userNotes)
            ->setAALoadDataOptions($aALoadDataOptions)
            ->setTravelerAdditionalInfo($travelerAdditionalInfo)
            ->setBookingCategoryType($bookingCategoryType);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\AAContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\AAContactInfoType $contactInfo
     * @return \StructType\AAAirBookRQExt
     */
    public function setContactInfo(\StructType\AAContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get UserNotes value
     * @return \StructType\AAUserNotesType|null
     */
    public function getUserNotes()
    {
        return $this->UserNotes;
    }
    /**
     * Set UserNotes value
     * @param \StructType\AAUserNotesType $userNotes
     * @return \StructType\AAAirBookRQExt
     */
    public function setUserNotes(\StructType\AAUserNotesType $userNotes = null)
    {
        $this->UserNotes = $userNotes;
        return $this;
    }
    /**
     * Get AALoadDataOptions value
     * @return \StructType\AALoadDataOptionsType|null
     */
    public function getAALoadDataOptions()
    {
        return $this->AALoadDataOptions;
    }
    /**
     * Set AALoadDataOptions value
     * @param \StructType\AALoadDataOptionsType $aALoadDataOptions
     * @return \StructType\AAAirBookRQExt
     */
    public function setAALoadDataOptions(\StructType\AALoadDataOptionsType $aALoadDataOptions = null)
    {
        $this->AALoadDataOptions = $aALoadDataOptions;
        return $this;
    }
    /**
     * Get TravelerAdditionalInfo value
     * @return \StructType\AATravelerInfoType|null
     */
    public function getTravelerAdditionalInfo()
    {
        return $this->TravelerAdditionalInfo;
    }
    /**
     * Set TravelerAdditionalInfo value
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     * @return \StructType\AAAirBookRQExt
     */
    public function setTravelerAdditionalInfo(\StructType\AATravelerInfoType $travelerAdditionalInfo = null)
    {
        $this->TravelerAdditionalInfo = $travelerAdditionalInfo;
        return $this;
    }
    /**
     * Get BookingCategoryType value
     * @return \StructType\AABookingCategoryType|null
     */
    public function getBookingCategoryType()
    {
        return $this->BookingCategoryType;
    }
    /**
     * Set BookingCategoryType value
     * @param \StructType\AABookingCategoryType $bookingCategoryType
     * @return \StructType\AAAirBookRQExt
     */
    public function setBookingCategoryType(\StructType\AABookingCategoryType $bookingCategoryType = null)
    {
        $this->BookingCategoryType = $bookingCategoryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAirBookRQExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
