<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAgentSeatMovemantRS StructType
 * Meta informations extracted from the WSDL
 * - type: ns3:AAAgentSeatMovemantRS
 * @subpackage Structs
 */
class AAAgentSeatMovemantRS extends AbstractStructBase
{
    /**
     * The inventorySeatMovements
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAAgentSeatMovementsType[]
     */
    public $inventorySeatMovements;
    /**
     * The statusErrorsAndWarnings
     * @var \StructType\AAStatusErrorsAndWarnings
     */
    public $statusErrorsAndWarnings;
    /**
     * The UserId
     * @var string
     */
    public $UserId;
    /**
     * The ChannelId
     * @var string
     */
    public $ChannelId;
    /**
     * Constructor method for AAAgentSeatMovemantRS
     * @uses AAAgentSeatMovemantRS::setInventorySeatMovements()
     * @uses AAAgentSeatMovemantRS::setStatusErrorsAndWarnings()
     * @uses AAAgentSeatMovemantRS::setUserId()
     * @uses AAAgentSeatMovemantRS::setChannelId()
     * @param \StructType\AAAgentSeatMovementsType[] $inventorySeatMovements
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @param string $userId
     * @param string $channelId
     */
    public function __construct(array $inventorySeatMovements = array(), \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null, $userId = null, $channelId = null)
    {
        $this
            ->setInventorySeatMovements($inventorySeatMovements)
            ->setStatusErrorsAndWarnings($statusErrorsAndWarnings)
            ->setUserId($userId)
            ->setChannelId($channelId);
    }
    /**
     * Get inventorySeatMovements value
     * @return \StructType\AAAgentSeatMovementsType[]|null
     */
    public function getInventorySeatMovements()
    {
        return $this->inventorySeatMovements;
    }
    /**
     * Set inventorySeatMovements value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAgentSeatMovementsType[] $inventorySeatMovements
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public function setInventorySeatMovements(array $inventorySeatMovements = array())
    {
        foreach ($inventorySeatMovements as $aAAgentSeatMovemantRSInventorySeatMovementsItem) {
            // validation for constraint: itemType
            if (!$aAAgentSeatMovemantRSInventorySeatMovementsItem instanceof \StructType\AAAgentSeatMovementsType) {
                throw new \InvalidArgumentException(sprintf('The inventorySeatMovements property can only contain items of \StructType\AAAgentSeatMovementsType, "%s" given', is_object($aAAgentSeatMovemantRSInventorySeatMovementsItem) ? get_class($aAAgentSeatMovemantRSInventorySeatMovementsItem) : gettype($aAAgentSeatMovemantRSInventorySeatMovementsItem)), __LINE__);
            }
        }
        $this->inventorySeatMovements = $inventorySeatMovements;
        return $this;
    }
    /**
     * Add item to inventorySeatMovements value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAgentSeatMovementsType $item
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public function addToInventorySeatMovements(\StructType\AAAgentSeatMovementsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAAgentSeatMovementsType) {
            throw new \InvalidArgumentException(sprintf('The inventorySeatMovements property can only contain items of \StructType\AAAgentSeatMovementsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->inventorySeatMovements[] = $item;
        return $this;
    }
    /**
     * Get statusErrorsAndWarnings value
     * @return \StructType\AAStatusErrorsAndWarnings|null
     */
    public function getStatusErrorsAndWarnings()
    {
        return $this->statusErrorsAndWarnings;
    }
    /**
     * Set statusErrorsAndWarnings value
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public function setStatusErrorsAndWarnings(\StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null)
    {
        $this->statusErrorsAndWarnings = $statusErrorsAndWarnings;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get ChannelId value
     * @return string|null
     */
    public function getChannelId()
    {
        return $this->ChannelId;
    }
    /**
     * Set ChannelId value
     * @param string $channelId
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channelId)), __LINE__);
        }
        $this->ChannelId = $channelId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAgentSeatMovemantRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
