<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAgentAvailCreditType StructType
 * @subpackage Structs
 */
class AAAgentAvailCreditType extends AbstractStructBase
{
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - documentation: Agent ID for which available credit amount is queried
     * @var string
     */
    public $AgentID;
    /**
     * The AgentName
     * Meta informations extracted from the WSDL
     * - documentation: Agent Name for which available credit amount is queried
     * - minOccurs: 0
     * @var string
     */
    public $AgentName;
    /**
     * The AvailableCredit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailableCredit
     */
    public $AvailableCredit;
    /**
     * Constructor method for AAAgentAvailCreditType
     * @uses AAAgentAvailCreditType::setAgentID()
     * @uses AAAgentAvailCreditType::setAgentName()
     * @uses AAAgentAvailCreditType::setAvailableCredit()
     * @param string $agentID
     * @param string $agentName
     * @param \StructType\AvailableCredit $availableCredit
     */
    public function __construct($agentID = null, $agentName = null, \StructType\AvailableCredit $availableCredit = null)
    {
        $this
            ->setAgentID($agentID)
            ->setAgentName($agentName)
            ->setAvailableCredit($availableCredit);
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \StructType\AAAgentAvailCreditType
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get AgentName value
     * @return string|null
     */
    public function getAgentName()
    {
        return $this->AgentName;
    }
    /**
     * Set AgentName value
     * @param string $agentName
     * @return \StructType\AAAgentAvailCreditType
     */
    public function setAgentName($agentName = null)
    {
        // validation for constraint: string
        if (!is_null($agentName) && !is_string($agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentName)), __LINE__);
        }
        $this->AgentName = $agentName;
        return $this;
    }
    /**
     * Get AvailableCredit value
     * @return \StructType\AvailableCredit|null
     */
    public function getAvailableCredit()
    {
        return $this->AvailableCredit;
    }
    /**
     * Set AvailableCredit value
     * @param \StructType\AvailableCredit $availableCredit
     * @return \StructType\AAAgentAvailCreditType
     */
    public function setAvailableCredit(\StructType\AvailableCredit $availableCredit = null)
    {
        $this->AvailableCredit = $availableCredit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAgentAvailCreditType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
