<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAdminInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reservation admin information.
 * @subpackage Structs
 */
class AAAdminInfoType extends AbstractStructBase
{
    /**
     * The OwnerChannelID
     * Meta informations extracted from the WSDL
     * - documentation: Sales Channel of which the booking is owned by.
     * - minOccurs: 0
     * @var string
     */
    public $OwnerChannelID;
    /**
     * The OwnerAgentCode
     * Meta informations extracted from the WSDL
     * - documentation: Agent which the booking is owned by.
     * - minOccurs: 0
     * @var string
     */
    public $OwnerAgentCode;
    /**
     * The OriginChannelID
     * Meta informations extracted from the WSDL
     * - documentation: Sales Channel of which the booking is originated from.
     * - minOccurs: 0
     * @var string
     */
    public $OriginChannelID;
    /**
     * The OriginAgentCode
     * Meta informations extracted from the WSDL
     * - documentation: Agent which the booking is originated from
     * - minOccurs: 0
     * @var string
     */
    public $OriginAgentCode;
    /**
     * The OriginSalesTerminal
     * Meta informations extracted from the WSDL
     * - documentation: Sales Terminal which the booking is originated from
     * - minOccurs: 0
     * @var string
     */
    public $OriginSalesTerminal;
    /**
     * The LastSalesTerminal
     * Meta informations extracted from the WSDL
     * - documentation: Sales Terminal which the last booking modification is originated from
     * - minOccurs: 0
     * @var string
     */
    public $LastSalesTerminal;
    /**
     * Constructor method for AAAdminInfoType
     * @uses AAAdminInfoType::setOwnerChannelID()
     * @uses AAAdminInfoType::setOwnerAgentCode()
     * @uses AAAdminInfoType::setOriginChannelID()
     * @uses AAAdminInfoType::setOriginAgentCode()
     * @uses AAAdminInfoType::setOriginSalesTerminal()
     * @uses AAAdminInfoType::setLastSalesTerminal()
     * @param string $ownerChannelID
     * @param string $ownerAgentCode
     * @param string $originChannelID
     * @param string $originAgentCode
     * @param string $originSalesTerminal
     * @param string $lastSalesTerminal
     */
    public function __construct($ownerChannelID = null, $ownerAgentCode = null, $originChannelID = null, $originAgentCode = null, $originSalesTerminal = null, $lastSalesTerminal = null)
    {
        $this
            ->setOwnerChannelID($ownerChannelID)
            ->setOwnerAgentCode($ownerAgentCode)
            ->setOriginChannelID($originChannelID)
            ->setOriginAgentCode($originAgentCode)
            ->setOriginSalesTerminal($originSalesTerminal)
            ->setLastSalesTerminal($lastSalesTerminal);
    }
    /**
     * Get OwnerChannelID value
     * @return string|null
     */
    public function getOwnerChannelID()
    {
        return $this->OwnerChannelID;
    }
    /**
     * Set OwnerChannelID value
     * @param string $ownerChannelID
     * @return \StructType\AAAdminInfoType
     */
    public function setOwnerChannelID($ownerChannelID = null)
    {
        // validation for constraint: string
        if (!is_null($ownerChannelID) && !is_string($ownerChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerChannelID)), __LINE__);
        }
        $this->OwnerChannelID = $ownerChannelID;
        return $this;
    }
    /**
     * Get OwnerAgentCode value
     * @return string|null
     */
    public function getOwnerAgentCode()
    {
        return $this->OwnerAgentCode;
    }
    /**
     * Set OwnerAgentCode value
     * @param string $ownerAgentCode
     * @return \StructType\AAAdminInfoType
     */
    public function setOwnerAgentCode($ownerAgentCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerAgentCode) && !is_string($ownerAgentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerAgentCode)), __LINE__);
        }
        $this->OwnerAgentCode = $ownerAgentCode;
        return $this;
    }
    /**
     * Get OriginChannelID value
     * @return string|null
     */
    public function getOriginChannelID()
    {
        return $this->OriginChannelID;
    }
    /**
     * Set OriginChannelID value
     * @param string $originChannelID
     * @return \StructType\AAAdminInfoType
     */
    public function setOriginChannelID($originChannelID = null)
    {
        // validation for constraint: string
        if (!is_null($originChannelID) && !is_string($originChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originChannelID)), __LINE__);
        }
        $this->OriginChannelID = $originChannelID;
        return $this;
    }
    /**
     * Get OriginAgentCode value
     * @return string|null
     */
    public function getOriginAgentCode()
    {
        return $this->OriginAgentCode;
    }
    /**
     * Set OriginAgentCode value
     * @param string $originAgentCode
     * @return \StructType\AAAdminInfoType
     */
    public function setOriginAgentCode($originAgentCode = null)
    {
        // validation for constraint: string
        if (!is_null($originAgentCode) && !is_string($originAgentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originAgentCode)), __LINE__);
        }
        $this->OriginAgentCode = $originAgentCode;
        return $this;
    }
    /**
     * Get OriginSalesTerminal value
     * @return string|null
     */
    public function getOriginSalesTerminal()
    {
        return $this->OriginSalesTerminal;
    }
    /**
     * Set OriginSalesTerminal value
     * @param string $originSalesTerminal
     * @return \StructType\AAAdminInfoType
     */
    public function setOriginSalesTerminal($originSalesTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($originSalesTerminal) && !is_string($originSalesTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originSalesTerminal)), __LINE__);
        }
        $this->OriginSalesTerminal = $originSalesTerminal;
        return $this;
    }
    /**
     * Get LastSalesTerminal value
     * @return string|null
     */
    public function getLastSalesTerminal()
    {
        return $this->LastSalesTerminal;
    }
    /**
     * Set LastSalesTerminal value
     * @param string $lastSalesTerminal
     * @return \StructType\AAAdminInfoType
     */
    public function setLastSalesTerminal($lastSalesTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($lastSalesTerminal) && !is_string($lastSalesTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSalesTerminal)), __LINE__);
        }
        $this->LastSalesTerminal = $lastSalesTerminal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAdminInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
