<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAddressType StructType
 * @subpackage Structs
 */
class AAAddressType extends AbstractStructBase
{
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine3;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The StateProvinceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StateProvinceName;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AACountryType
     */
    public $CountryName;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for AAAddressType
     * @uses AAAddressType::setAddressLine1()
     * @uses AAAddressType::setAddressLine2()
     * @uses AAAddressType::setAddressLine3()
     * @uses AAAddressType::setCityName()
     * @uses AAAddressType::setStateProvinceName()
     * @uses AAAddressType::setCountryName()
     * @uses AAAddressType::setZipCode()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $cityName
     * @param string $stateProvinceName
     * @param \StructType\AACountryType $countryName
     * @param string $zipCode
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $cityName = null, $stateProvinceName = null, \StructType\AACountryType $countryName = null, $zipCode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setCityName($cityName)
            ->setStateProvinceName($stateProvinceName)
            ->setCountryName($countryName)
            ->setZipCode($zipCode);
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\AAAddressType
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\AAAddressType
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get AddressLine3 value
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->AddressLine3;
    }
    /**
     * Set AddressLine3 value
     * @param string $addressLine3
     * @return \StructType\AAAddressType
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine3)), __LINE__);
        }
        $this->AddressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\AAAddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get StateProvinceName value
     * @return string|null
     */
    public function getStateProvinceName()
    {
        return $this->StateProvinceName;
    }
    /**
     * Set StateProvinceName value
     * @param string $stateProvinceName
     * @return \StructType\AAAddressType
     */
    public function setStateProvinceName($stateProvinceName = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvinceName) && !is_string($stateProvinceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProvinceName)), __LINE__);
        }
        $this->StateProvinceName = $stateProvinceName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return \StructType\AACountryType|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param \StructType\AACountryType $countryName
     * @return \StructType\AAAddressType
     */
    public function setCountryName(\StructType\AACountryType $countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\AAAddressType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
