<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateEticketStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_ETicketStatusUpdateRQ $aA_OTA_ETicketStatusUpdateRQ
     * @return \StructType\AA_OTA_ETicketStatusUpdateRS|bool
     */
    public function updateEticketStatus(\StructType\AA_OTA_ETicketStatusUpdateRQ $aA_OTA_ETicketStatusUpdateRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEticketStatus($aA_OTA_ETicketStatusUpdateRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateOptimizedInventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAUpdateOptimizedInventoryRQ $aAUpdateOptimizedInventoryRQ
     * @return \StructType\AAUpdateOptimizedInventoryRS|bool
     */
    public function updateOptimizedInventory(\StructType\AAUpdateOptimizedInventoryRQ $aAUpdateOptimizedInventoryRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->updateOptimizedInventory($aAUpdateOptimizedInventoryRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePFS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_PFSUpdateRQ $aA_OTA_PFSUpdateRQ
     * @return \StructType\AA_OTA_PFSUpdateRS|bool
     */
    public function updatePFS(\StructType\AA_OTA_PFSUpdateRQ $aA_OTA_PFSUpdateRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePFS($aA_OTA_PFSUpdateRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AAUpdateOptimizedInventoryRS|\StructType\AA_OTA_ETicketStatusUpdateRS|\StructType\AA_OTA_PFSUpdateRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
