<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSeatMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirSeatMapRQ $oTA_AirSeatMapRQ
     * @return \StructType\OTA_AirSeatMapRS|bool
     */
    public function getSeatMap(\StructType\OTA_AirSeatMapRQ $oTA_AirSeatMapRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getSeatMap($oTA_AirSeatMapRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIOBoundPaxCountInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAFligthtLegPaxCountInfoRQ $aAFligthtLegPaxCountInfoRQ
     * @return \StructType\AAIOBoundPaxCountInfoRS|bool
     */
    public function getIOBoundPaxCountInfo(\StructType\AAFligthtLegPaxCountInfoRQ $aAFligthtLegPaxCountInfoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getIOBoundPaxCountInfo($aAFligthtLegPaxCountInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaxTypesForFlightLeg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAFligthtLegPaxCountInfoRQ $aAFligthtLegPaxCountInfoRQ
     * @return \StructType\AAFligthtLegPaxCountInfoRS|bool
     */
    public function getPaxTypesForFlightLeg(\StructType\AAFligthtLegPaxCountInfoRQ $aAFligthtLegPaxCountInfoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getPaxTypesForFlightLeg($aAFligthtLegPaxCountInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReservationbyPNR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $oTA_ReadRQ
     * @param \StructType\AAReadRQExt $aAReadRQExt
     * @return \StructType\OTA_AirBookRS|bool
     */
    public function getReservationbyPNR(\StructType\OTA_ReadRQ $oTA_ReadRQ, \StructType\AAReadRQExt $aAReadRQExt)
    {
        try {
            $this->setResult(self::getSoapClient()->getReservationbyPNR($oTA_ReadRQ, $aAReadRQExt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAgentSeatSellingReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAAgentSeatMovemantRQ $aAAgentSeatMovemantRQ
     * @return \StructType\AAAgentSeatMovemantRS|bool
     */
    public function getAgentSeatSellingReport(\StructType\AAAgentSeatMovemantRQ $aAAgentSeatMovemantRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getAgentSeatSellingReport($aAAgentSeatMovemantRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirAvailRQ $oTA_AirAvailRQ
     * @return \StructType\OTA_AirAvailRS|bool
     */
    public function getAvailability(\StructType\OTA_AirAvailRQ $oTA_AirAvailRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getAvailability($oTA_AirAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTermsNConditions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_TermsNConditionsRQ $aA_OTA_TermsNConditionsRQ
     * @return \StructType\AA_OTA_TermsNConditionsRS|bool
     */
    public function getTermsNConditions(\StructType\AA_OTA_TermsNConditionsRQ $aA_OTA_TermsNConditionsRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getTermsNConditions($aA_OTA_TermsNConditionsRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResAuditHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_ResAuditReadRQ $aA_OTA_ResAuditReadRQ
     * @return \StructType\AA_OTA_ResAuditRS|bool
     */
    public function getResAuditHistory(\StructType\AA_OTA_ResAuditReadRQ $aA_OTA_ResAuditReadRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getResAuditHistory($aA_OTA_ResAuditReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFlightInventoryAllocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAFlightInventorySearchRQ $aAFlightInventorySearchRQ
     * @return \StructType\AAFlightInventoryDataRS|bool
     */
    public function getFlightInventoryAllocations(\StructType\AAFlightInventorySearchRQ $aAFlightInventorySearchRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getFlightInventoryAllocations($aAFlightInventorySearchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInsuranceQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_InsuranceQuoteRQ $oTA_InsuranceQuoteRQ
     * @return \StructType\OTA_InsuranceQuoteRS|bool
     */
    public function getInsuranceQuote(\StructType\OTA_InsuranceQuoteRQ $oTA_InsuranceQuoteRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getInsuranceQuote($oTA_InsuranceQuoteRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSSRDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_AirSSRDetailsRQ $aA_OTA_AirSSRDetailsRQ
     * @return \StructType\AA_OTA_AirSSRDetailsRS|bool
     */
    public function getSSRDetails(\StructType\AA_OTA_AirSSRDetailsRQ $aA_OTA_AirSSRDetailsRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getSSRDetails($aA_OTA_AirSSRDetailsRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMealDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_AirMealDetailsRQ $aA_OTA_AirMealDetailsRQ
     * @return \StructType\AA_OTA_AirMealDetailsRS|bool
     */
    public function getMealDetails(\StructType\AA_OTA_AirMealDetailsRQ $aA_OTA_AirMealDetailsRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getMealDetails($aA_OTA_AirMealDetailsRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFlightInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirFlifoRQ $oTA_AirFlifoRQ
     * @return \StructType\OTA_AirFlifoRS|bool
     */
    public function getFlightInfo(\StructType\OTA_AirFlifoRQ $oTA_AirFlifoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getFlightInfo($oTA_AirFlifoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAgentSalesData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAPNRPaxTicketingDataRQ $aAPNRPaxTicketingDataRQ
     * @return \StructType\AAPNRPaxTicketingDataRS|bool
     */
    public function getAgentSalesData(\StructType\AAPNRPaxTicketingDataRQ $aAPNRPaxTicketingDataRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getAgentSalesData($aAPNRPaxTicketingDataRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFlightSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirScheduleRQ $oTA_AirScheduleRQ
     * @return \StructType\OTA_AirScheduleRS|bool
     */
    public function getFlightSchedule(\StructType\OTA_AirScheduleRQ $oTA_AirScheduleRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getFlightSchedule($oTA_AirScheduleRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirPriceRQ $oTA_AirPriceRQ
     * @return \StructType\OTA_AirPriceRS|bool
     */
    public function getPrice(\StructType\OTA_AirPriceRQ $oTA_AirPriceRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrice($oTA_AirPriceRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAgentAvailableCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_AgentAvailCreditRQ $aA_OTA_AgentAvailCreditRQ
     * @return \StructType\AA_OTA_AgentAvailCreditRS|bool
     */
    public function getAgentAvailableCredit(\StructType\AA_OTA_AgentAvailCreditRQ $aA_OTA_AgentAvailCreditRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getAgentAvailableCredit($aA_OTA_AgentAvailCreditRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPassengerCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_PaxCreditReadRQ $aA_OTA_PaxCreditReadRQ
     * @return \StructType\AA_OTA_PaxCreditRS|bool
     */
    public function getPassengerCredit(\StructType\AA_OTA_PaxCreditReadRQ $aA_OTA_PaxCreditReadRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getPassengerCredit($aA_OTA_PaxCreditReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReservationsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $oTA_ReadRQ
     * @param \StructType\AAReadRQExt $aAReadRQExt
     * @return \StructType\OTA_ResRetrieveRS|bool
     */
    public function getReservationsList(\StructType\OTA_ReadRQ $oTA_ReadRQ, \StructType\AAReadRQExt $aAReadRQExt)
    {
        try {
            $this->setResult(self::getSoapClient()->getReservationsList($oTA_ReadRQ, $aAReadRQExt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFlightLoadInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAFlightLoadInfoRQ $aAFlightLoadInfoRQ
     * @return \StructType\AAFlightLoadInfoRS|bool
     */
    public function getFlightLoadInfo(\StructType\AAFlightLoadInfoRQ $aAFlightLoadInfoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getFlightLoadInfo($aAFlightLoadInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getItinerary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $oTA_ReadRQ
     * @return \StructType\AA_OTA_ItineraryRS|bool
     */
    public function getItinerary(\StructType\OTA_ReadRQ $oTA_ReadRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getItinerary($oTA_ReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBaggageDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_AirBaggageDetailsRQ $aA_OTA_AirBaggageDetailsRQ
     * @return \StructType\AA_OTA_AirBaggageDetailsRS|bool
     */
    public function getBaggageDetails(\StructType\AA_OTA_AirBaggageDetailsRQ $aA_OTA_AirBaggageDetailsRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->getBaggageDetails($aA_OTA_AirBaggageDetailsRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AAAgentSeatMovemantRS|\StructType\AAFlightInventoryDataRS|\StructType\AAFlightLoadInfoRS|\StructType\AAFligthtLegPaxCountInfoRS|\StructType\AAIOBoundPaxCountInfoRS|\StructType\AAPNRPaxTicketingDataRS|\StructType\AA_OTA_AgentAvailCreditRS|\StructType\AA_OTA_AirBaggageDetailsRS|\StructType\AA_OTA_AirMealDetailsRS|\StructType\AA_OTA_AirSSRDetailsRS|\StructType\AA_OTA_ItineraryRS|\StructType\AA_OTA_PaxCreditRS|\StructType\AA_OTA_ResAuditRS|\StructType\AA_OTA_TermsNConditionsRS|\StructType\OTA_AirAvailRS|\StructType\OTA_AirBookRS|\StructType\OTA_AirFlifoRS|\StructType\OTA_AirPriceRS|\StructType\OTA_AirScheduleRS|\StructType\OTA_AirSeatMapRS|\StructType\OTA_InsuranceQuoteRS|\StructType\OTA_ResRetrieveRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
