<?php

namespace EnumType;

/**
 * This class stands for GlobalIndicatorType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Specifies the global travel area.
 * @subpackage Enumerations
 */
class GlobalIndicatorType
{
    /**
     * Constant for value 'AT'
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'PA'
     * @return string 'PA'
     */
    const VALUE_PA = 'PA';
    /**
     * Constant for value 'WH'
     * @return string 'WH'
     */
    const VALUE_WH = 'WH';
    /**
     * Constant for value 'EH'
     * @return string 'EH'
     */
    const VALUE_EH = 'EH';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'TS'
     * @return string 'TS'
     */
    const VALUE_TS = 'TS';
    /**
     * Constant for value 'AP'
     * @return string 'AP'
     */
    const VALUE_AP = 'AP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AT
     * @uses self::VALUE_PA
     * @uses self::VALUE_WH
     * @uses self::VALUE_EH
     * @uses self::VALUE_PO
     * @uses self::VALUE_TS
     * @uses self::VALUE_AP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AT,
            self::VALUE_PA,
            self::VALUE_WH,
            self::VALUE_EH,
            self::VALUE_PO,
            self::VALUE_TS,
            self::VALUE_AP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
