<?php

namespace EnumType;

/**
 * This class stands for EticketUserbilityStatusType EnumType
 * @subpackage Enumerations
 */
class EticketUserbilityStatusType
{
    /**
     * Constant for value 'OK_CIN'
     * @return string 'OK_CIN'
     */
    const VALUE_OK_CIN = 'OK_CIN';
    /**
     * Constant for value 'NO_CIN'
     * @return string 'NO_CIN'
     */
    const VALUE_NO_CIN = 'NO_CIN';
    /**
     * Constant for value 'OK_BDD'
     * @return string 'OK_BDD'
     */
    const VALUE_OK_BDD = 'OK_BDD';
    /**
     * Constant for value 'NO_BDD'
     * @return string 'NO_BDD'
     */
    const VALUE_NO_BDD = 'NO_BDD';
    /**
     * Constant for value 'OK_OPN'
     * @return string 'OK_OPN'
     */
    const VALUE_OK_OPN = 'OK_OPN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK_CIN
     * @uses self::VALUE_NO_CIN
     * @uses self::VALUE_OK_BDD
     * @uses self::VALUE_NO_BDD
     * @uses self::VALUE_OK_OPN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK_CIN,
            self::VALUE_NO_CIN,
            self::VALUE_OK_BDD,
            self::VALUE_NO_BDD,
            self::VALUE_OK_OPN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
