<?php

namespace EnumType;

/**
 * This class stands for ETicketUsedStatusType EnumType
 * @subpackage Enumerations
 */
class ETicketUsedStatusType
{
    /**
     * Constant for value 'USED'
     * @return string 'USED'
     */
    const VALUE_USED = 'USED';
    /**
     * Constant for value 'UNUSED'
     * @return string 'UNUSED'
     */
    const VALUE_UNUSED = 'UNUSED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USED
     * @uses self::VALUE_UNUSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USED,
            self::VALUE_UNUSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
