<?php

namespace EnumType;

/**
 * This class stands for ActionType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Identifes an action to take place.
 * @subpackage Enumerations
 */
class ActionType
{
    /**
     * Constant for value 'Add-Update'
     * @return string 'Add-Update'
     */
    const VALUE_ADD_UPDATE = 'Add-Update';
    /**
     * Constant for value 'Cancel'
     * @return string 'Cancel'
     */
    const VALUE_CANCEL = 'Cancel';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Add'
     * @return string 'Add'
     */
    const VALUE_ADD = 'Add';
    /**
     * Constant for value 'Replace'
     * @return string 'Replace'
     */
    const VALUE_REPLACE = 'Replace';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_UPDATE
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_ADD
     * @uses self::VALUE_REPLACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_UPDATE,
            self::VALUE_CANCEL,
            self::VALUE_DELETE,
            self::VALUE_ADD,
            self::VALUE_REPLACE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
