<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://egate.erv.de/exiws201802/ExiConnector?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://egate.erv.de/exiws201802/ExiConnector?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\ClassMap::get(),
);
/**
 * Samples for Request ServiceType
 */
$request = new \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\ServiceType\Request($options);
/**
 * Sample call for requestOffer operation/method
 */
if ($request->requestOffer(new \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for requestCancellation operation/method
 */
if ($request->requestCancellation(new \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for requestBooking operation/method
 */
if ($request->requestBooking(new \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for requestPreContractualInformation operation/method
 */
if ($request->requestPreContractualInformation(new \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
