<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for travelType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for travel information [Typ fuer Reiseinformationen]
 * @subpackage Structs
 */
class TravelType extends AbstractStructBase
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - documentation: Angabe des Reiseziels, um den Geltungsbereich der zu buchenden Versicherungsleistung ermitteln zu können. | Trip destination
     * - minOccurs: 1
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public $destination;
    /**
     * The time
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public $time;
    /**
     * The tripType
     * Meta informations extracted from the WSDL
     * - documentation: Angabe des Verkehrsmittels | Travel type.
     * - minOccurs: 0
     * @var string
     */
    public $tripType;
    /**
     * The totalTripCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost
     */
    public $totalTripCost;
    /**
     * The tariffCategory
     * Meta informations extracted from the WSDL
     * - documentation: versobject type
     * - minOccurs: 0
     * @var string
     */
    public $tariffCategory;
    /**
     * Constructor method for travelType
     * @uses TravelType::setDestination()
     * @uses TravelType::setTime()
     * @uses TravelType::setTripType()
     * @uses TravelType::setTotalTripCost()
     * @uses TravelType::setTariffCategory()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType $destination
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time $time
     * @param string $tripType
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost $totalTripCost
     * @param string $tariffCategory
     */
    public function __construct(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType $destination = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time $time = null, $tripType = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost $totalTripCost = null, $tariffCategory = null)
    {
        $this
            ->setDestination($destination)
            ->setTime($time)
            ->setTripType($tripType)
            ->setTotalTripCost($totalTripCost)
            ->setTariffCategory($tariffCategory);
    }
    /**
     * Get destination value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType $destination
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public function setDestination(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get time value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time $time
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public function setTime(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time $time = null)
    {
        $this->time = $time;
        return $this;
    }
    /**
     * Get tripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->tripType;
    }
    /**
     * Set tripType value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TripTypeType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TripTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripType
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TripTypeType::valueIsValid($tripType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripType, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TripTypeType::getValidValues())), __LINE__);
        }
        $this->tripType = $tripType;
        return $this;
    }
    /**
     * Get totalTripCost value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost|null
     */
    public function getTotalTripCost()
    {
        return $this->totalTripCost;
    }
    /**
     * Set totalTripCost value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost $totalTripCost
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public function setTotalTripCost(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalTripCost $totalTripCost = null)
    {
        $this->totalTripCost = $totalTripCost;
        return $this;
    }
    /**
     * Get tariffCategory value
     * @return string|null
     */
    public function getTariffCategory()
    {
        return $this->tariffCategory;
    }
    /**
     * Set tariffCategory value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TariffCategoryType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TariffCategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tariffCategory
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public function setTariffCategory($tariffCategory = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TariffCategoryType::valueIsValid($tariffCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tariffCategory, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\TariffCategoryType::getValidValues())), __LINE__);
        }
        $this->tariffCategory = $tariffCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
