<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for thanx StructType
 * @subpackage Structs
 */
class Thanx extends AbstractStructBase
{
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: confirmation text [Text fuer Buchungsbestaetigung]
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $text;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: link for confirmation text [Link mit Verweis auf Bestaetigungstext]
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType
     */
    public $link;
    /**
     * Constructor method for thanx
     * @uses Thanx::setText()
     * @uses Thanx::setLink()
     * @param string $text
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link
     */
    public function __construct($text = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link = null)
    {
        $this
            ->setText($text)
            ->setLink($link);
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx
     */
    public function setText($text = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($text) && strlen($text) > 1000) || (is_array($text) && count($text) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($text) ? strlen($text) : count($text)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($text) && strlen($text) < 1) || (is_array($text) && count($text) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get link value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx
     */
    public function setLink(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link = null)
    {
        $this->link = $link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
