<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tariffsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for tariff list [Typ fuer Tarifliste]
 * @subpackage Structs
 */
class TariffsType extends AbstractStructBase
{
    /**
     * The tariff
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff[]
     */
    public $tariff;
    /**
     * Constructor method for tariffsType
     * @uses TariffsType::setTariff()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff[] $tariff
     */
    public function __construct(array $tariff = array())
    {
        $this
            ->setTariff($tariff);
    }
    /**
     * Get tariff value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff[]|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @throws \InvalidArgumentException
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff[] $tariff
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType
     */
    public function setTariff(array $tariff = array())
    {
        foreach ($tariff as $tariffsTypeTariffItem) {
            // validation for constraint: itemType
            if (!$tariffsTypeTariffItem instanceof \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff) {
                throw new \InvalidArgumentException(sprintf('The tariff property can only contain items of \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff, "%s" given', is_object($tariffsTypeTariffItem) ? get_class($tariffsTypeTariffItem) : gettype($tariffsTypeTariffItem)), __LINE__);
            }
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Add item to tariff value
     * @throws \InvalidArgumentException
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff $item
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType
     */
    public function addToTariff(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff) {
            throw new \InvalidArgumentException(sprintf('The tariff property can only contain items of \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tariff[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
