<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceRenewalPremium StructType
 * Meta informations extracted from the WSDL
 * - documentation: service renewal price [Servicepreis] | type for servicePremium [Typ fuer ERV Service-Prämie]
 * - maxLength: 130
 * - minLength: 0
 * @subpackage Structs
 */
class ServiceRenewalPremium extends AbstractStructBase
{
    /**
     * The premiumtype
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $premiumtype;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: type for servicePremium [Typ fuer ERV Service-Prämie]
     * - maxLength: 130
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * Constructor method for serviceRenewalPremium
     * @uses ServiceRenewalPremium::setPremiumtype()
     * @uses ServiceRenewalPremium::set_()
     * @param string $premiumtype
     * @param string $_
     */
    public function __construct($premiumtype = null, $_ = null)
    {
        $this
            ->setPremiumtype($premiumtype)
            ->set_($_);
    }
    /**
     * Get premiumtype value
     * @return string
     */
    public function getPremiumtype()
    {
        return $this->premiumtype;
    }
    /**
     * Set premiumtype value
     * @param string $premiumtype
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium
     */
    public function setPremiumtype($premiumtype = null)
    {
        // validation for constraint: string
        if (!is_null($premiumtype) && !is_string($premiumtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumtype)), __LINE__);
        }
        $this->premiumtype = $premiumtype;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 130) || (is_array($_) && count($_) > 130)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 130 element(s) or a scalar of 130 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($_) && strlen($_) < 0) || (is_array($_) && count($_) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
