<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for service StructType
 * Meta informations extracted from the WSDL
 * - documentation: service [Leistung]
 * @subpackage Structs
 */
class Service extends ServiceType
{
    /**
     * The servicetype
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Used for Character Strings, length 1 to 50.
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $servicetype;
    /**
     * Constructor method for service
     * @uses Service::setServicetype()
     * @param string $servicetype
     */
    public function __construct($servicetype = null)
    {
        $this
            ->setServicetype($servicetype);
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($servicetype) && strlen($servicetype) > 50) || (is_array($servicetype) && count($servicetype) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($servicetype) ? strlen($servicetype) : count($servicetype)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($servicetype) && strlen($servicetype) < 1) || (is_array($servicetype) && count($servicetype) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
