<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseBooking StructType
 * Meta informations extracted from the WSDL
 * - documentation: response with booking confirmation [Response mit Buchungsantwort]
 * @subpackage Structs
 */
class ResponseBooking extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The responseID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for responseID [Typ fuer responseID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $responseID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType
     */
    public $system;
    /**
     * The agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType
     */
    public $agent;
    /**
     * The policy
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public $policy;
    /**
     * The thanx
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx
     */
    public $thanx;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * The userError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType
     */
    public $userError;
    /**
     * The systemError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType
     */
    public $systemError;
    /**
     * Constructor method for responseBooking
     * @uses ResponseBooking::setRequestID()
     * @uses ResponseBooking::setResponseID()
     * @uses ResponseBooking::setSystem()
     * @uses ResponseBooking::setAgent()
     * @uses ResponseBooking::setPolicy()
     * @uses ResponseBooking::setThanx()
     * @uses ResponseBooking::setExtensions()
     * @uses ResponseBooking::setUserError()
     * @uses ResponseBooking::setSystemError()
     * @param string $requestID
     * @param string $responseID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType $agent
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx $thanx
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     */
    public function __construct($requestID = null, $responseID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType $agent = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx $thanx = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null)
    {
        $this
            ->setRequestID($requestID)
            ->setResponseID($responseID)
            ->setSystem($system)
            ->setAgent($agent)
            ->setPolicy($policy)
            ->setThanx($thanx)
            ->setExtensions($extensions)
            ->setUserError($userError)
            ->setSystemError($systemError);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get responseID value
     * @return string
     */
    public function getResponseID()
    {
        return $this->responseID;
    }
    /**
     * Set responseID value
     * @param string $responseID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($responseID) && strlen($responseID) > 100) || (is_array($responseID) && count($responseID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($responseID) ? strlen($responseID) : count($responseID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($responseID) && strlen($responseID) < 1) || (is_array($responseID) && count($responseID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($responseID) && !is_string($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseID)), __LINE__);
        }
        $this->responseID = $responseID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get agent value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType $agent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setAgent(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get policy value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setPolicy(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get thanx value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx|null
     */
    public function getThanx()
    {
        return $this->thanx;
    }
    /**
     * Set thanx value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx $thanx
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setThanx(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Thanx $thanx = null)
    {
        $this->thanx = $thanx;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Get userError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType|null
     */
    public function getUserError()
    {
        return $this->userError;
    }
    /**
     * Set userError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setUserError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null)
    {
        $this->userError = $userError;
        return $this;
    }
    /**
     * Get systemError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType|null
     */
    public function getSystemError()
    {
        return $this->systemError;
    }
    /**
     * Set systemError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public function setSystemError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null)
    {
        $this->systemError = $systemError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
