<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestPreContractualInformation StructType
 * Meta informations extracted from the WSDL
 * - documentation: request with demand of booking [Request mit Anforderung einer Buchung]
 * @subpackage Structs
 */
class RequestPreContractualInformation extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType
     */
    public $system;
    /**
     * The agent
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public $agent;
    /**
     * The offerID
     * Meta informations extracted from the WSDL
     * - documentation: Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer] | Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer] | Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer]
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $offerID;
    /**
     * The travel
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public $travel;
    /**
     * The coveredTravelers
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType
     */
    public $coveredTravelers;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - documentation: customer [Vertragsnehmer]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public $customer;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * Constructor method for requestPreContractualInformation
     * @uses RequestPreContractualInformation::setRequestID()
     * @uses RequestPreContractualInformation::setSystem()
     * @uses RequestPreContractualInformation::setAgent()
     * @uses RequestPreContractualInformation::setOfferID()
     * @uses RequestPreContractualInformation::setTravel()
     * @uses RequestPreContractualInformation::setCoveredTravelers()
     * @uses RequestPreContractualInformation::setCustomer()
     * @uses RequestPreContractualInformation::setExtensions()
     * @param string $requestID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @param string $offerID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     */
    public function __construct($requestID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null, $offerID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this
            ->setRequestID($requestID)
            ->setSystem($system)
            ->setAgent($agent)
            ->setOfferID($offerID)
            ->setTravel($travel)
            ->setCoveredTravelers($coveredTravelers)
            ->setCustomer($customer)
            ->setExtensions($extensions);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get agent value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setAgent(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get offerID value
     * @return string|null
     */
    public function getOfferID()
    {
        return $this->offerID;
    }
    /**
     * Set offerID value
     * @param string $offerID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($offerID) && strlen($offerID) > 500) || (is_array($offerID) && count($offerID) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($offerID) ? strlen($offerID) : count($offerID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($offerID) && strlen($offerID) < 1) || (is_array($offerID) && count($offerID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offerID)), __LINE__);
        }
        $this->offerID = $offerID;
        return $this;
    }
    /**
     * Get travel value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType|null
     */
    public function getTravel()
    {
        return $this->travel;
    }
    /**
     * Set travel value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setTravel(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null)
    {
        $this->travel = $travel;
        return $this;
    }
    /**
     * Get coveredTravelers value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType|null
     */
    public function getCoveredTravelers()
    {
        return $this->coveredTravelers;
    }
    /**
     * Set coveredTravelers value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setCoveredTravelers(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers = null)
    {
        $this->coveredTravelers = $coveredTravelers;
        return $this;
    }
    /**
     * Get customer value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setCustomer(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
