<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestOffer StructType
 * Meta informations extracted from the WSDL
 * - documentation: request for demand of ERV offers [Request mit Anforderung von ERV Angeboten]
 * @subpackage Structs
 */
class RequestOffer extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType
     */
    public $system;
    /**
     * The agent
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public $agent;
    /**
     * The providerData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType
     */
    public $providerData;
    /**
     * The productSpec
     * Meta informations extracted from the WSDL
     * - documentation: poduct specifica
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType
     */
    public $productSpec;
    /**
     * The customerResidenceCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Customer Country Code ISO 3166-1-Alpha-3 [Wohnitz] | Used for Alpha Strings, length 3
     * - minOccurs: 0
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string
     */
    public $customerResidenceCountryCode;
    /**
     * The travel
     * Meta informations extracted from the WSDL
     * - documentation: travel data [Reise]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public $travel;
    /**
     * The searchTravelers
     * Meta informations extracted from the WSDL
     * - documentation: traveler data [Versicherte Personen]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType
     */
    public $searchTravelers;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * Constructor method for requestOffer
     * @uses RequestOffer::setRequestID()
     * @uses RequestOffer::setSystem()
     * @uses RequestOffer::setAgent()
     * @uses RequestOffer::setProviderData()
     * @uses RequestOffer::setProductSpec()
     * @uses RequestOffer::setCustomerResidenceCountryCode()
     * @uses RequestOffer::setTravel()
     * @uses RequestOffer::setSearchTravelers()
     * @uses RequestOffer::setExtensions()
     * @param string $requestID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec
     * @param string $customerResidenceCountryCode
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType $searchTravelers
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     */
    public function __construct($requestID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec = null, $customerResidenceCountryCode = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType $searchTravelers = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this
            ->setRequestID($requestID)
            ->setSystem($system)
            ->setAgent($agent)
            ->setProviderData($providerData)
            ->setProductSpec($productSpec)
            ->setCustomerResidenceCountryCode($customerResidenceCountryCode)
            ->setTravel($travel)
            ->setSearchTravelers($searchTravelers)
            ->setExtensions($extensions);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get agent value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setAgent(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get providerData value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType|null
     */
    public function getProviderData()
    {
        return $this->providerData;
    }
    /**
     * Set providerData value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setProviderData(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData = null)
    {
        $this->providerData = $providerData;
        return $this;
    }
    /**
     * Get productSpec value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType|null
     */
    public function getProductSpec()
    {
        return $this->productSpec;
    }
    /**
     * Set productSpec value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setProductSpec(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec = null)
    {
        $this->productSpec = $productSpec;
        return $this;
    }
    /**
     * Get customerResidenceCountryCode value
     * @return string|null
     */
    public function getCustomerResidenceCountryCode()
    {
        return $this->customerResidenceCountryCode;
    }
    /**
     * Set customerResidenceCountryCode value
     * @param string $customerResidenceCountryCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setCustomerResidenceCountryCode($customerResidenceCountryCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($customerResidenceCountryCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $customerResidenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($customerResidenceCountryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerResidenceCountryCode) && !is_string($customerResidenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerResidenceCountryCode)), __LINE__);
        }
        $this->customerResidenceCountryCode = $customerResidenceCountryCode;
        return $this;
    }
    /**
     * Get travel value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType|null
     */
    public function getTravel()
    {
        return $this->travel;
    }
    /**
     * Set travel value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setTravel(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null)
    {
        $this->travel = $travel;
        return $this;
    }
    /**
     * Get searchTravelers value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType|null
     */
    public function getSearchTravelers()
    {
        return $this->searchTravelers;
    }
    /**
     * Set searchTravelers value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType $searchTravelers
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setSearchTravelers(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SearchTravelersType $searchTravelers = null)
    {
        $this->searchTravelers = $searchTravelers;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
