<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestCancellation StructType
 * Meta informations extracted from the WSDL
 * - documentation: request for cancellation of an ERV insurance [Request zur Stornierung einer ERV Versicherung]
 * @subpackage Structs
 */
class RequestCancellation extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType
     */
    public $system;
    /**
     * The agent
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public $agent;
    /**
     * The policy
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public $policy;
    /**
     * Constructor method for requestCancellation
     * @uses RequestCancellation::setRequestID()
     * @uses RequestCancellation::setSystem()
     * @uses RequestCancellation::setAgent()
     * @uses RequestCancellation::setPolicy()
     * @param string $requestID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy
     */
    public function __construct($requestID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy = null)
    {
        $this
            ->setRequestID($requestID)
            ->setSystem($system)
            ->setAgent($agent)
            ->setPolicy($policy);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get agent value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation
     */
    public function setAgent(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get policy value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation
     */
    public function setPolicy(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
