<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container für personenbezogene Daten. | Container for person data
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The personName
     * Meta informations extracted from the WSDL
     * - documentation: Namensdaten der Person. | Name data of the person
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType
     */
    public $personName;
    /**
     * The birthdate
     * Meta informations extracted from the WSDL
     * - documentation: Geburtsdatum | Birthdate
     * @var string
     */
    public $birthdate;
    /**
     * The age
     * Meta informations extracted from the WSDL
     * - documentation: Alter | Age
     * @var int
     */
    public $age;
    /**
     * Constructor method for personType
     * @uses PersonType::setPersonName()
     * @uses PersonType::setBirthdate()
     * @uses PersonType::setAge()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType $personName
     * @param string $birthdate
     * @param int $age
     */
    public function __construct(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType $personName = null, $birthdate = null, $age = null)
    {
        $this
            ->setPersonName($personName)
            ->setBirthdate($birthdate)
            ->setAge($age);
    }
    /**
     * Get personName value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->personName;
    }
    /**
     * Set personName value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType $personName
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType
     */
    public function setPersonName(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType $personName = null)
    {
        $this->personName = $personName;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthdate)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->age;
    }
    /**
     * Set age value
     * @param int $age
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->age = $age;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
