<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for travellers name [Typ fuer Namen der Reisende]
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: form of salutation [Anrede]
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The prename
     * Meta informations extracted from the WSDL
     * - documentation: firstname [Vorname] | Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $prename;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - documentation: lastname [Nachname] | Used for Character Strings, length 0 to 60.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $surname;
    /**
     * Constructor method for personNameType
     * @uses PersonNameType::setAddress()
     * @uses PersonNameType::setPrename()
     * @uses PersonNameType::setSurname()
     * @param string $address
     * @param string $prename
     * @param string $surname
     */
    public function __construct($address = null, $prename = null, $surname = null)
    {
        $this
            ->setAddress($address)
            ->setPrename($prename)
            ->setSurname($surname);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressTravellerType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressTravellerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressTravellerType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressTravellerType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get prename value
     * @return string|null
     */
    public function getPrename()
    {
        return $this->prename;
    }
    /**
     * Set prename value
     * @param string $prename
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType
     */
    public function setPrename($prename = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prename) && strlen($prename) > 30) || (is_array($prename) && count($prename) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($prename) ? strlen($prename) : count($prename)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($prename) && strlen($prename) < 1) || (is_array($prename) && count($prename) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prename) && !is_string($prename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prename)), __LINE__);
        }
        $this->prename = $prename;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($surname) && strlen($surname) > 60) || (is_array($surname) && count($surname) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($surname) ? strlen($surname) : count($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($surname) && strlen($surname) < 1) || (is_array($surname) && count($surname) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
