<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for payment [Typ fuer Zahlung]
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - documentation: payment method [Zahlungsweise]
     * @var string
     */
    public $method;
    /**
     * The cc
     * Meta informations extracted from the WSDL
     * - documentation: pay with credit card
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public $cc;
    /**
     * The bank
     * Meta informations extracted from the WSDL
     * - documentation: pay with bank collection
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public $bank;
    /**
     * Constructor method for paymentType
     * @uses PaymentType::setMethod()
     * @uses PaymentType::setCc()
     * @uses PaymentType::setBank()
     * @param string $method
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType $cc
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType $bank
     */
    public function __construct($method = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType $cc = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType $bank = null)
    {
        $this
            ->setMethod($method)
            ->setCc($cc)
            ->setBank($bank);
    }
    /**
     * Get method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\PaymentMethodType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\PaymentMethodType::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $method, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get cc value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType|null
     */
    public function getCc()
    {
        return $this->cc;
    }
    /**
     * Set cc value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType $cc
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType
     */
    public function setCc(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType $cc = null)
    {
        $this->cc = $cc;
        return $this;
    }
    /**
     * Get bank value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType|null
     */
    public function getBank()
    {
        return $this->bank;
    }
    /**
     * Set bank value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType $bank
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType
     */
    public function setBank(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType $bank = null)
    {
        $this->bank = $bank;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
