<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for linkType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for link representation [Typ für Linkdarstellung]
 * @subpackage Structs
 */
class LinkType extends AbstractStructBase
{
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - documentation: link text [Linktext] | Used for Character Strings, length 0 to 50
     * - maxLength: 50
     * - minLength: 0
     * @var string
     */
    public $label;
    /**
     * The href
     * Meta informations extracted from the WSDL
     * - documentation: url [URL] | Used for Character Strings, length 0 to 100
     * - maxLength: 100
     * - minLength: 0
     * @var string
     */
    public $href;
    /**
     * Constructor method for linkType
     * @uses LinkType::setLabel()
     * @uses LinkType::setHref()
     * @param string $label
     * @param string $href
     */
    public function __construct($label = null, $href = null)
    {
        $this
            ->setLabel($label)
            ->setHref($href);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($label) && strlen($label) < 0) || (is_array($label) && count($label) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get href value
     * @return string|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType
     */
    public function setHref($href = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($href) && strlen($href) > 100) || (is_array($href) && count($href) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($href) ? strlen($href) : count($href)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($href) && strlen($href) < 0) || (is_array($href) && count($href) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
