<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for destinationType StructType
 * @subpackage Structs
 */
class DestinationType extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: ISO3166 country code | ISO3166 country code | Used for Alpha Strings, length 3
     * - maxOccurs: unbounded
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string[]
     */
    public $countryCode;
    /**
     * The airportCode
     * Meta informations extracted from the WSDL
     * - documentation: IATA airport code | IATA airport code | Used for Alpha Strings, length 3
     * - maxOccurs: unbounded
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string[]
     */
    public $airportCode;
    /**
     * Constructor method for destinationType
     * @uses DestinationType::setCountryCode()
     * @uses DestinationType::setAirportCode()
     * @param string[] $countryCode
     * @param string[] $airportCode
     */
    public function __construct(array $countryCode = array(), array $airportCode = array())
    {
        $this
            ->setCountryCode($countryCode)
            ->setAirportCode($airportCode);
    }
    /**
     * Get countryCode value
     * @return string[]|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @throws \InvalidArgumentException
     * @param string[] $countryCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public function setCountryCode(array $countryCode = array())
    {
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        foreach ($countryCode as $destinationTypeCountryCodeItem) {
            // validation for constraint: itemType
            if (!is_string($destinationTypeCountryCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The countryCode property can only contain items of string, "%s" given', is_object($destinationTypeCountryCodeItem) ? get_class($destinationTypeCountryCodeItem) : gettype($destinationTypeCountryCodeItem)), __LINE__);
            }
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Add item to countryCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public function addToCountryCode($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The countryCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->countryCode[] = $item;
        return $this;
    }
    /**
     * Get airportCode value
     * @return string[]|null
     */
    public function getAirportCode()
    {
        return $this->airportCode;
    }
    /**
     * Set airportCode value
     * @throws \InvalidArgumentException
     * @param string[] $airportCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public function setAirportCode(array $airportCode = array())
    {
        // validation for constraint: pattern
        if (is_scalar($airportCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($airportCode, true)), __LINE__);
        }
        foreach ($airportCode as $destinationTypeAirportCodeItem) {
            // validation for constraint: itemType
            if (!is_string($destinationTypeAirportCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The airportCode property can only contain items of string, "%s" given', is_object($destinationTypeAirportCodeItem) ? get_class($destinationTypeAirportCodeItem) : gettype($destinationTypeAirportCodeItem)), __LINE__);
            }
        }
        $this->airportCode = $airportCode;
        return $this;
    }
    /**
     * Add item to airportCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public function addToAirportCode($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The airportCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->airportCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DestinationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
