<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for customer [Typ fuer Versicherungsnehmer]
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Country Code ISO 3166-1-Alpha-3 [Wohnitz] | Used for Alpha Strings, length 3
     * - minOccurs: 1
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string
     */
    public $countryCode;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: form of salutation [Anrede]
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The prename
     * Meta informations extracted from the WSDL
     * - documentation: first name [Vorname] | Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $prename;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - documentation: last name [Nachname] | Used for Character Strings, length 0 to 60.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $surname;
    /**
     * The streetAndNr
     * Meta informations extracted from the WSDL
     * - documentation: name of street and number [Strasse und Hausnummer] | Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $streetAndNr;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - documentation: zip code [PLZ] | Used for Character Strings, length 1 to 7.
     * - maxLength: 7
     * - minLength: 1
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - documentation: city [ort] | Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $city;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: email address [Email] | Used for Character Strings, length 1 to 100
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * The telPriv
     * Meta informations extracted from the WSDL
     * - documentation: telephone private [Telefonnummer privat] | telephone private [Telefonnummer privat] | type for telephonenumber [Typ fuer Telefonnummer]
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $telPriv;
    /**
     * The telBiz
     * Meta informations extracted from the WSDL
     * - documentation: telephone business [Telefonnummer geschaeftliche] | type for telephonenumber [Typ fuer Telefonnummer]
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $telBiz;
    /**
     * The telMobile
     * Meta informations extracted from the WSDL
     * - documentation: telephone mobile [Telefonnummer mobil] | type for telephonenumber [Typ fuer Telefonnummer]
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $telMobile;
    /**
     * Constructor method for customerType
     * @uses CustomerType::setCountryCode()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setPrename()
     * @uses CustomerType::setSurname()
     * @uses CustomerType::setStreetAndNr()
     * @uses CustomerType::setZipCode()
     * @uses CustomerType::setCity()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setTelPriv()
     * @uses CustomerType::setTelBiz()
     * @uses CustomerType::setTelMobile()
     * @param string $countryCode
     * @param string $address
     * @param string $prename
     * @param string $surname
     * @param string $streetAndNr
     * @param string $zipCode
     * @param string $city
     * @param string $email
     * @param string $telPriv
     * @param string $telBiz
     * @param string $telMobile
     */
    public function __construct($countryCode = null, $address = null, $prename = null, $surname = null, $streetAndNr = null, $zipCode = null, $city = null, $email = null, $telPriv = null, $telBiz = null, $telMobile = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setAddress($address)
            ->setPrename($prename)
            ->setSurname($surname)
            ->setStreetAndNr($streetAndNr)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setEmail($email)
            ->setTelPriv($telPriv)
            ->setTelBiz($telBiz)
            ->setTelMobile($telMobile);
    }
    /**
     * Get countryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressCustomerType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressCustomerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressCustomerType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressCustomerType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get prename value
     * @return string|null
     */
    public function getPrename()
    {
        return $this->prename;
    }
    /**
     * Set prename value
     * @param string $prename
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setPrename($prename = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prename) && strlen($prename) > 30) || (is_array($prename) && count($prename) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($prename) ? strlen($prename) : count($prename)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($prename) && strlen($prename) < 1) || (is_array($prename) && count($prename) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prename) && !is_string($prename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prename)), __LINE__);
        }
        $this->prename = $prename;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($surname) && strlen($surname) > 60) || (is_array($surname) && count($surname) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($surname) ? strlen($surname) : count($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($surname) && strlen($surname) < 1) || (is_array($surname) && count($surname) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get streetAndNr value
     * @return string|null
     */
    public function getStreetAndNr()
    {
        return $this->streetAndNr;
    }
    /**
     * Set streetAndNr value
     * @param string $streetAndNr
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setStreetAndNr($streetAndNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($streetAndNr) && strlen($streetAndNr) > 30) || (is_array($streetAndNr) && count($streetAndNr) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($streetAndNr) ? strlen($streetAndNr) : count($streetAndNr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($streetAndNr) && strlen($streetAndNr) < 1) || (is_array($streetAndNr) && count($streetAndNr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetAndNr) && !is_string($streetAndNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAndNr)), __LINE__);
        }
        $this->streetAndNr = $streetAndNr;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zipCode) && strlen($zipCode) > 7) || (is_array($zipCode) && count($zipCode) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($zipCode) ? strlen($zipCode) : count($zipCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($zipCode) && strlen($zipCode) < 1) || (is_array($zipCode) && count($zipCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 30) || (is_array($city) && count($city) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 100) || (is_array($email) && count($email) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($email) && strlen($email) < 1) || (is_array($email) && count($email) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get telPriv value
     * @return string|null
     */
    public function getTelPriv()
    {
        return $this->telPriv;
    }
    /**
     * Set telPriv value
     * @param string $telPriv
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setTelPriv($telPriv = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telPriv) && strlen($telPriv) > 30) || (is_array($telPriv) && count($telPriv) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($telPriv) ? strlen($telPriv) : count($telPriv)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telPriv) && !is_string($telPriv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telPriv)), __LINE__);
        }
        $this->telPriv = $telPriv;
        return $this;
    }
    /**
     * Get telBiz value
     * @return string|null
     */
    public function getTelBiz()
    {
        return $this->telBiz;
    }
    /**
     * Set telBiz value
     * @param string $telBiz
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setTelBiz($telBiz = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telBiz) && strlen($telBiz) > 30) || (is_array($telBiz) && count($telBiz) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($telBiz) ? strlen($telBiz) : count($telBiz)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telBiz) && !is_string($telBiz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telBiz)), __LINE__);
        }
        $this->telBiz = $telBiz;
        return $this;
    }
    /**
     * Get telMobile value
     * @return string|null
     */
    public function getTelMobile()
    {
        return $this->telMobile;
    }
    /**
     * Set telMobile value
     * @param string $telMobile
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public function setTelMobile($telMobile = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telMobile) && strlen($telMobile) > 30) || (is_array($telMobile) && count($telMobile) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($telMobile) ? strlen($telMobile) : count($telMobile)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telMobile) && !is_string($telMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telMobile)), __LINE__);
        }
        $this->telMobile = $telMobile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
